/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.util.VecUtil;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class RealBB
extends AxisAlignedBB {
    private double front;
    private double rear;
    private double width;
    private double height;
    private float yaw;
    private double centerX;
    private double centerY;
    private double centerZ;
    private double[][] heightMap;

    public RealBB(double front, double rear, double width, double height, float yaw) {
        this(front, rear, width, height, yaw, null);
    }

    public RealBB(double front, double rear, double width, double height, float yaw, double[][] heightMap) {
        this(front, rear, width, height, yaw, 0.0, 0.0, 0.0, heightMap);
    }

    private RealBB(double front, double rear, double width, double height, float yaw, double centerX, double centerY, double centerZ, double[][] heightMap) {
        this(RealBB.constructorParams(front, rear, width, height, yaw, centerX, centerY, centerZ));
        this.front = front;
        this.rear = rear;
        this.width = width;
        this.height = height;
        this.yaw = yaw;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.heightMap = heightMap;
    }

    private RealBB(double[] constructorParams) {
        super(constructorParams[0], constructorParams[1], constructorParams[2], constructorParams[3], constructorParams[4], constructorParams[5]);
    }

    private static AxisAlignedBB newBB(Vec3d min, Vec3d max) {
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    private static double[] constructorParams(double front, double rear, double width, double height, float yaw, double centerX, double centerY, double centerZ) {
        Vec3d frontPos = VecUtil.fromWrongYaw(front, yaw);
        Vec3d rearPos = VecUtil.fromWrongYaw(rear, yaw);
        Vec3d offsetRight = VecUtil.fromWrongYaw(width / 2.0, yaw + 90.0f);
        Vec3d offsetLeft = VecUtil.fromWrongYaw(width / 2.0, yaw - 90.0f);
        AxisAlignedBB rightBox = RealBB.newBB(frontPos.func_178787_e(offsetRight), rearPos.func_178787_e(offsetRight));
        AxisAlignedBB leftBox = RealBB.newBB(frontPos.func_178787_e(offsetLeft), rearPos.func_178787_e(offsetLeft));
        AxisAlignedBB newthis = rightBox.func_111270_a(leftBox).func_72317_d(centerX, centerY, centerZ);
        return new double[]{newthis.field_72336_d, newthis.field_72337_e + height, newthis.field_72334_f, newthis.field_72340_a, newthis.field_72338_b, newthis.field_72339_c};
    }

    public RealBB clone() {
        return new RealBB(this.front, this.rear, this.width, this.height, this.yaw, this.centerX, this.centerY, this.centerZ, this.heightMap);
    }

    public RealBB cloneRaw() {
        RealBB clone = new RealBB(new double[]{this.field_72340_a, this.field_72338_b, this.field_72339_c, this.field_72336_d, this.field_72337_e, this.field_72334_f});
        clone.front = this.front;
        clone.rear = this.rear;
        clone.width = this.width;
        clone.height = this.height;
        clone.yaw = this.yaw;
        clone.centerX = this.centerX;
        clone.centerY = this.centerY;
        clone.centerZ = this.centerZ;
        clone.heightMap = this.heightMap;
        return clone;
    }

    public AxisAlignedBB func_186666_e(double y2) {
        return this.cloneRaw();
    }

    public AxisAlignedBB func_191195_a(double x, double y, double z) {
        RealBB expanded = this.cloneRaw();
        if (x > 0.0) {
            expanded.front -= x;
        } else {
            expanded.rear -= x;
        }
        if (y > 0.0) {
            expanded.height -= y;
        } else {
            expanded.centerY -= y;
        }
        expanded.width -= z;
        return expanded.clone();
    }

    public AxisAlignedBB func_72321_a(double x, double y, double z) {
        RealBB expanded = this.cloneRaw();
        if (x > 0.0) {
            expanded.front += x;
        } else {
            expanded.rear += x;
        }
        if (y > 0.0) {
            expanded.height += y;
        } else {
            expanded.centerY += y;
        }
        expanded.width += z;
        return expanded.clone();
    }

    public AxisAlignedBB func_72314_b(double x, double y, double z) {
        RealBB growed = this.cloneRaw();
        growed.front += x;
        growed.rear += x;
        growed.height += y;
        growed.centerY += y;
        growed.width += z + z;
        return growed.clone();
    }

    public AxisAlignedBB func_191500_a(AxisAlignedBB p_191500_1_) {
        return this.cloneRaw();
    }

    public AxisAlignedBB func_111270_a(AxisAlignedBB other) {
        return this.cloneRaw();
    }

    public AxisAlignedBB func_186670_a(BlockPos pos) {
        return this.func_72317_d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public AxisAlignedBB func_191194_a(Vec3d vec) {
        return this.func_72317_d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public AxisAlignedBB func_72317_d(double x, double y, double z) {
        RealBB offsetted = this.cloneRaw();
        offsetted.centerX += x;
        offsetted.centerY += y;
        offsetted.centerZ += z;
        return offsetted.clone();
    }

    public double func_72316_a(AxisAlignedBB other, double offsetX) {
        return 0.0;
    }

    public double func_72323_b(AxisAlignedBB other, double offsetY) {
        double hack = 0.04;
        other = other.func_72314_b(hack, 0.0, hack);
        Double intersect = (Double)this.intersectsAt(other.field_72340_a, other.field_72338_b, other.field_72339_c, other.field_72336_d, other.field_72337_e, other.field_72334_f, true).getRight();
        if (other.field_72338_b < intersect) {
            return Math.min(0.1, intersect - other.field_72338_b);
        }
        return 0.0;
    }

    public double func_72322_c(AxisAlignedBB other, double offsetZ) {
        return 0.0;
    }

    public boolean func_186668_a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return (Boolean)this.intersectsAt(minX, minY, minZ, maxX, maxY, maxZ, true).getLeft();
    }

    public Pair<Boolean, Double> intersectsAt(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, boolean useHeightmap) {
        if (!super.func_186668_a(minX, minY, minZ, maxX, maxY, maxZ)) {
            return Pair.of((Object)false, (Object)minY);
        }
        double actualYMin = this.centerY;
        double actualYMax = this.centerY + this.height;
        if (!(actualYMin < maxY) || !(actualYMax > minY)) {
            return Pair.of((Object)false, (Object)minY);
        }
        Rectangle2D.Double otherRect = new Rectangle2D.Double(minX, minZ, 0.0, 0.0);
        if (minX == maxX && minZ == maxZ) {
            otherRect.add(maxX + 0.2, maxZ + 0.2);
        } else {
            otherRect.add(maxX, maxZ);
        }
        Rectangle2D.Double myRect = new Rectangle2D.Double(this.rear, -this.width / 2.0, 0.0, 0.0);
        myRect.add(this.front, this.width / 2.0);
        Area otherArea = new Area(otherRect);
        Area myArea = new Area(myRect);
        AffineTransform myTransform = new AffineTransform();
        myTransform.translate(this.centerX, this.centerZ);
        myArea.transform(myTransform);
        AffineTransform otherTransform = new AffineTransform();
        otherTransform.rotate(Math.toRadians(180.0f - this.yaw + 90.0f), this.centerX, this.centerZ);
        otherArea.transform(otherTransform);
        if (!otherArea.intersects(myArea.getBounds2D())) {
            return Pair.of((Object)false, (Object)minY);
        }
        if (this.heightMap != null && useHeightmap) {
            int xRes = this.heightMap.length - 1;
            int zRes = this.heightMap[0].length - 1;
            double length = this.front - this.rear;
            actualYMin = this.centerY;
            actualYMax = this.centerY;
            Rectangle2D bds = otherArea.getBounds2D();
            double px = bds.getMinX() - (this.centerX - length / 2.0);
            double pz = bds.getMinY() - (this.centerZ - this.width / 2.0);
            double Px = bds.getMaxX() - (this.centerX - length / 2.0);
            double Pz = bds.getMaxY() - (this.centerZ - this.width / 2.0);
            double cx = Math.max(0.0, Math.min(length, px));
            double cz = Math.max(0.0, Math.min(this.width, pz));
            double Cx = Math.max(0.0, Math.min(length, Px));
            double Cz = Math.max(0.0, Math.min(this.width, Pz));
            cx = cx / length * (double)xRes;
            cz = cz / this.width * (double)zRes;
            Cx = Cx / length * (double)xRes;
            Cz = Cz / this.width * (double)zRes;
            for (int x = (int)cx; x < (int)Cx; ++x) {
                for (int z = (int)cz; z < (int)Cz; ++z) {
                    actualYMax = Math.max(actualYMax, this.centerY + this.height * this.heightMap[x][z]);
                }
            }
            return Pair.of((Object)(actualYMin < maxY && actualYMax > minY ? 1 : 0), (Object)actualYMax);
        }
        return Pair.of((Object)true, (Object)this.field_72337_e);
    }

    public boolean func_72318_a(Vec3d vec) {
        return (Boolean)this.intersectsAt(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, false).getLeft();
    }

    public RayTraceResult func_72327_a(Vec3d vecA, Vec3d vecB) {
        int steps = 10;
        double xDist = vecB.field_72450_a - vecA.field_72450_a;
        double yDist = vecB.field_72448_b - vecA.field_72448_b;
        double zDist = vecB.field_72449_c - vecA.field_72449_c;
        double xDelta = xDist / (double)steps;
        double yDelta = yDist / (double)steps;
        double zDelta = zDist / (double)steps;
        for (int step = 0; step < steps; ++step) {
            Vec3d stepPos = new Vec3d(vecA.field_72450_a + xDelta * (double)step, vecA.field_72448_b + yDelta * (double)step, vecA.field_72449_c + zDelta * (double)step);
            if (!this.func_72318_a(stepPos)) continue;
            return new RayTraceResult(stepPos, EnumFacing.UP);
        }
        return null;
    }

    public AxisAlignedBB withHeightMap(double[][] heightMap) {
        RealBB bb = this.cloneRaw();
        bb.heightMap = heightMap;
        return bb;
    }
}

