/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class SwitchUtil {
    public static SwitchState getSwitchState(TileRail rail) {
        return SwitchUtil.getSwitchState(rail, null);
    }

    public static SwitchState getSwitchState(TileRail rail, Vec3d position) {
        if (rail == null) {
            return SwitchState.NONE;
        }
        if (!rail.isLoaded()) {
            return SwitchState.NONE;
        }
        TileRail parent = rail.getParentTile();
        if (parent == null || !parent.isLoaded()) {
            return SwitchState.NONE;
        }
        if (rail.info.settings.type != TrackItems.TURN && rail.info.settings.type != TrackItems.CUSTOM) {
            return SwitchState.NONE;
        }
        if (parent.info.settings.type != TrackItems.SWITCH) {
            return SwitchState.NONE;
        }
        if (position != null && parent.info != null) {
            IIterableTrack switchBuilder = (IIterableTrack)((Object)parent.info.getBuilder());
            IIterableTrack turnBuilder = (IIterableTrack)((Object)rail.info.getBuilder());
            boolean isOnStraight = switchBuilder.isOnTrack(parent.info, position);
            boolean isOnTurn = turnBuilder.isOnTrack(rail.info, position);
            if (isOnStraight && !isOnTurn) {
                return SwitchState.STRAIGHT;
            }
            if (!isOnStraight && isOnTurn) {
                return SwitchState.NONE;
            }
        }
        if (parent.isSwitchForced()) {
            return parent.info.switchForced;
        }
        if (SwitchUtil.isRailPowered(rail)) {
            return SwitchState.TURN;
        }
        return SwitchState.STRAIGHT;
    }

    public static boolean isRailPowered(TileRail rail) {
        Vec3d redstoneOrigin = rail.info.placementInfo.placementPosition;
        double horiz = rail.info.settings.gauge.scale() * 1.1;
        if (Config.ConfigDebug.oldNarrowWidth && rail.info.settings.gauge.value() < 1.0) {
            horiz /= 2.0;
        }
        int scale = (int)Math.round(horiz);
        for (int x = -scale; x <= scale; ++x) {
            for (int z = -scale; z <= scale; ++z) {
                BlockPos gagPos = new BlockPos(redstoneOrigin.func_178787_e(new Vec3d((double)x, 0.0, (double)z)));
                TileRailBase gagRail = TileRailBase.get((IBlockAccess)rail.func_145831_w(), gagPos);
                if (gagRail == null || !rail.func_174877_v().equals((Object)gagRail.getParent()) && gagRail.getReplaced() == null || rail.func_145831_w().func_175687_A(gagPos) <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

