/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public abstract class AbstractDirectedTurret
extends TurretHead {
    protected float pitch;
    protected float yaw;
    protected float maxPitch = 360.0f;
    protected float maxYaw = 360.0f;
    protected float minPitch = 0.0f;
    protected float minYaw = 0.0f;

    public AbstractDirectedTurret(int turretTier) {
        super(turretTier);
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 2, var1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound var1 = pkt.func_148857_g();
        this.func_145839_a(var1);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74776_a("pitch", this.pitch);
        nbtTagCompound.func_74776_a("yaw", this.yaw);
        nbtTagCompound.func_74776_a("maxPitch", this.maxPitch);
        nbtTagCompound.func_74776_a("minPitch", this.minPitch);
        nbtTagCompound.func_74776_a("maxYaw", this.maxYaw);
        nbtTagCompound.func_74776_a("minYaw", this.minYaw);
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.pitch = nbtTagCompound.func_74760_g("pitch");
        this.yaw = nbtTagCompound.func_74760_g("yaw");
        this.maxPitch = nbtTagCompound.func_74760_g("maxPitch");
        this.minPitch = nbtTagCompound.func_74760_g("minPitch");
        this.maxYaw = nbtTagCompound.func_74760_g("maxYaw");
        this.minYaw = nbtTagCompound.func_74760_g("minYaw");
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(float maxPitch) {
        this.maxPitch = maxPitch;
    }

    public float getMinPitch() {
        return this.minPitch;
    }

    public void setMinPitch(float minPitch) {
        this.minPitch = minPitch;
    }

    public float getMaxYaw() {
        return this.maxYaw;
    }

    public void setMaxYaw(float maxYaw) {
        this.maxYaw = maxYaw;
    }

    public float getMinYaw() {
        return this.minYaw;
    }

    public void setMinYaw(float minYaw) {
        this.minYaw = minYaw;
    }

    protected abstract void doTargetedShot(Entity var1, ItemStack var2);

    public abstract boolean forceShot();

    protected void updateRotationAnimation() {
        if (this.rotationAnimation >= 360.0f) {
            this.rotationAnimation = 0.0f;
        }
        this.rotationAnimation += 0.03f;
    }

    protected boolean isTargetInYawPitch(Entity entity) {
        while (this.yaw > 360.0f || this.pitch > 360.0f || this.yaw < 0.0f || this.pitch < 0.0f) {
            if (this.yaw > 360.0f) {
                this.yaw -= 360.0f;
            }
            if (this.pitch > 360.0f) {
                this.pitch -= 360.0f;
            }
            if (this.yaw < 0.0f) {
                this.yaw += 360.0f;
            }
            if (!(this.pitch < 0.0f)) continue;
            this.pitch += 360.0f;
        }
        return this.minYaw <= this.yaw && this.yaw <= this.maxYaw && this.minPitch <= this.pitch && this.pitch <= this.maxPitch;
    }

    public void func_73660_a() {
        if (!this.setSide()) {
            return;
        }
        if (this.base == null) {
            this.base = this.getBaseFromWorld();
        }
        if (!(this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() instanceof BlockAbstractTurretHead)) {
            return;
        }
        if (this.ticks % 5 == 0) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
        }
        ++this.ticks;
        if (this.base == null || this.base.getTier() < this.turretTier) {
            this.func_145831_w().func_175655_b(this.field_174879_c, true);
            return;
        }
        if (!this.base.isActive()) {
            this.target = null;
            return;
        }
        if (this.func_145831_w().field_72995_K) {
            this.updateRotationAnimation();
            return;
        }
        if (this.ticks % 5 == 0) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
        }
        TurretHeadUtil.updateSolarPanelAddon(this.base);
        this.concealmentChecks();
        if (this.base.getEnergyStored(EnumFacing.DOWN) < this.getPowerRequiredForNextShot()) {
            return;
        }
        if (this.base.isAttacksPlayers() && OMTConfig.TURRETS.globalCanTargetPlayers) {
            TurretHeadUtil.warnPlayers(this.base, this.base.func_145831_w(), this.field_174879_c, this.getTurretBaseRange());
        }
        if (this.target instanceof EntityPlayerMP) {
            this.targetSpeedX = this.target.field_70165_t - this.targetLastX;
            this.targetSpeedY = this.target.field_70163_u - this.targetLastY;
            this.targetSpeedZ = this.target.field_70161_v - this.targetLastZ;
            this.targetLastX = this.target.field_70165_t;
            this.targetLastY = this.target.field_70163_u;
            this.targetLastZ = this.target.field_70161_v;
        }
        if (this.target == null && this.targetingTicks < OMTConfig.TURRETS.turretTargetSearchTicks) {
            ++this.targetingTicks;
        } else {
            this.targetingChecks();
            if (this.target != null && this.isTargetInYawPitch(this.target)) {
                this.yaw = TurretHeadUtil.getAimYaw(this.target, this.field_174879_c);
                this.pitch = TurretHeadUtil.getAimPitch(this.target, this.field_174879_c);
            }
            this.targetingTicks = 0;
        }
        if (this.target != null || this.autoFire) {
            if ((float)this.ticks < (float)this.getTurretBaseFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(this.base, this))) {
                return;
            }
            ItemStack ammo = this.getAmmoStack();
            if (ammo == ItemStack.field_190927_a && this.requiresAmmo()) {
                return;
            }
            if (this.target != null) {
                this.doTargetedShot(this.target, ammo);
            } else if (this.autoFire) {
                this.forceShot();
            }
            this.ticks = 0;
        }
    }
}

