/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import omtteam.omlib.util.MathUtil;
import omtteam.omlib.util.RandomUtil;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.turrets.AbstractDirectedTurret;
import omtteam.openmodularturrets.tileentity.turrets.RocketTurretTileEntity;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public abstract class ProjectileTurret
extends AbstractDirectedTurret {
    public ProjectileTurret(int tier) {
        super(tier);
    }

    protected abstract float getProjectileGravity();

    public abstract TurretProjectile createProjectile(World var1, Entity var2, ItemStack var3);

    @Override
    protected void doTargetedShot(Entity target, ItemStack ammo) {
        double speedX = target instanceof EntityPlayerMP ? this.targetSpeedX : target.field_70165_t - target.field_70169_q;
        double speedY = target instanceof EntityPlayerMP ? this.targetSpeedY : target.field_70163_u - target.field_70167_r;
        double speedZ = target instanceof EntityPlayerMP ? this.targetSpeedZ : target.field_70161_v - target.field_70166_s;
        double d0 = target.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
        double d1 = target.field_70163_u + (double)target.field_70131_O * 0.5 - ((double)this.field_174879_c.func_177956_o() + 0.5);
        double d2 = target.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
        double dist = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        double inaccuracy = this.getBaseTurretAccuracy() / 10.0 * (double)(1.0f - TurretHeadUtil.getAccuraccyUpgrades(this.base, this)) * (double)(1 + TurretHeadUtil.getScattershotUpgrades(this.base));
        double time = dist / (this.getProjectileGravity() == 0.0f ? 3.0 : 1.6);
        double adjustedX = d0 + speedX * time;
        double adjustedY = d1 + speedY * time;
        double adjustedZ = d2 + speedZ * time;
        double dist2 = MathHelper.func_76133_a((double)(adjustedX * adjustedX + adjustedY * adjustedY + adjustedZ * adjustedZ));
        float speedFactor = (float)(dist2 / dist);
        this.shootProjectile(adjustedX, adjustedY - (double)0.1f, adjustedZ, 3.0f * speedFactor, (float)inaccuracy, ammo);
    }

    @Override
    public boolean forceShot() {
        if (this instanceof RocketTurretTileEntity && OMTConfig.TURRETS.canRocketsHome) {
            return false;
        }
        if ((float)this.ticks < (float)this.getTurretBaseFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(this.base, this))) {
            return false;
        }
        ItemStack ammo = this.getAmmoStack();
        if (ammo == ItemStack.field_190927_a && this.requiresAmmo()) {
            return false;
        }
        this.base.setEnergyStored(this.base.getEnergyStored(EnumFacing.DOWN) - this.getPowerRequiredForNextShot(), null);
        for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
            Vec3d velocity;
            double accuracy = this.getActualTurretAccuracy() / 20.0;
            TurretProjectile projectile = this.createProjectile(this.func_145831_w(), this.target, ammo);
            projectile.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            if (projectile.gravity == 0.0f) {
                velocity = MathUtil.getVelocityVectorFromYawPitch((float)this.pitch, (float)this.yaw, (float)3.0f);
                projectile.func_70186_c(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, (float)velocity.func_72433_c(), (float)accuracy);
            } else {
                projectile.field_70177_z = this.yaw;
                projectile.field_70125_A = this.pitch;
                velocity = MathUtil.getVelocityVectorFromYawPitch((float)projectile.field_70177_z, (float)projectile.field_70125_A, (float)1.6f);
                projectile.field_70159_w = velocity.field_72450_a + RandomUtil.random.nextGaussian() * (double)0.0075f * accuracy;
                projectile.field_70181_x = velocity.field_72448_b + RandomUtil.random.nextGaussian() * (double)0.0075f * accuracy;
                projectile.field_70179_y = velocity.field_72449_c + RandomUtil.random.nextGaussian() * (double)0.0075f * accuracy;
                projectile.field_70126_B = projectile.field_70177_z;
                projectile.field_70127_C = projectile.field_70125_A;
            }
            this.func_145831_w().func_72838_d((Entity)projectile);
        }
        this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getLaunchSoundEffect(), SoundCategory.BLOCKS, OMTConfig.TURRETS.turretSoundVolume, new Random().nextFloat() + 0.5f);
        this.ticks = 0;
        return true;
    }

    protected void shootProjectile(double adjustedX, double adjustedY, double adjustedZ, float speedFactor, float accuracy, ItemStack ammo) {
        this.base.setEnergyStored(this.base.getEnergyStored(EnumFacing.DOWN) - this.getPowerRequiredForNextShot(), null);
        for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
            TurretProjectile projectile = this.createProjectile(this.func_145831_w(), this.target, ammo);
            projectile.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            projectile.func_70186_c(adjustedX, adjustedY, adjustedZ, speedFactor, accuracy);
            projectile.amp_level = TurretHeadUtil.getAmpLevel(this.base);
            if (projectile.amp_level != 0) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, ModSounds.amped, SoundCategory.BLOCKS, OMTConfig.TURRETS.turretSoundVolume, RandomUtil.random.nextFloat() + 0.5f);
                projectile.isAmped = true;
            }
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getLaunchSoundEffect(), SoundCategory.BLOCKS, OMTConfig.TURRETS.turretSoundVolume, new Random().nextFloat() + 0.5f);
            this.func_145831_w().func_72838_d((Entity)projectile);
        }
    }
}

