/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.utils;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.machinemuse.numina.capabilities.energy.adapter.ElectricAdapter;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.nbt.MuseNBTUtils;
import net.machinemuse.numina.string.MuseStringUtils;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.utils.modulehelpers.FluidUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MuseCommonStrings {
    public static void addInformation(@Nonnull ItemStack stack, World worldIn, List currentTipList, ITooltipFlag advancedToolTips) {
        ElectricAdapter adapter;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (currentTipList.contains(I18n.func_135052_a((String)"silkTouch", (Object[])new Object[0]))) {
            currentTipList.remove(I18n.func_135052_a((String)"silkTouch", (Object[])new Object[0]));
        }
        if (stack.func_77973_b() instanceof IModeChangingItem) {
            String moduleDataName = MuseItemUtils.getStringOrNull((ItemStack)stack, (String)"mode");
            if (moduleDataName != null) {
                String localizedName = I18n.func_135052_a((String)("module.powersuits." + moduleDataName + ".name"), (Object[])new Object[0]);
                currentTipList.add(I18n.func_135052_a((String)"tooltip.powersuits.mode", (Object[])new Object[0]) + " " + MuseStringUtils.wrapFormatTags((String)localizedName, (MuseStringUtils.FormatCodes)MuseStringUtils.FormatCodes.Red));
            } else {
                currentTipList.add(I18n.func_135052_a((String)"tooltip.powersuits.changeModes", (Object[])new Object[0]));
            }
        }
        if ((adapter = ElectricAdapter.wrap((ItemStack)stack)) != null) {
            String energyinfo = I18n.func_135052_a((String)"tooltip.powersuits.energy", (Object[])new Object[0]) + " " + MuseStringUtils.formatNumberShort((double)adapter.getEnergyStored()) + '/' + MuseStringUtils.formatNumberShort((double)adapter.getMaxEnergyStored());
            currentTipList.add(MuseStringUtils.wrapMultipleFormatTags((String)energyinfo, (Object[])new Object[]{Character.valueOf(MuseStringUtils.FormatCodes.Italic.character), MuseStringUtils.FormatCodes.Aqua}));
        }
        if (MPSConfig.INSTANCE.doAdditionalInfo()) {
            List<String> installed;
            if (stack.func_77973_b() instanceof ItemPowerArmorChestplate) {
                FluidUtils fluidUtils = new FluidUtils((EntityPlayer)player, stack, "basicCoolingSystem");
                List<String> fluidInfo = fluidUtils.getFluidDisplayString();
                if (!fluidInfo.isEmpty()) {
                    currentTipList.addAll(fluidInfo);
                }
                if (!(fluidInfo = (fluidUtils = new FluidUtils((EntityPlayer)player, stack, "advancedCoolingSystem")).getFluidDisplayString()).isEmpty()) {
                    currentTipList.addAll(fluidInfo);
                }
            }
            if ((installed = MuseCommonStrings.getItemInstalledModules((EntityPlayer)player, stack)).size() == 0) {
                String message = I18n.func_135052_a((String)"tooltip.powersuits.noModules", (Object[])new Object[0]);
                currentTipList.addAll(MuseStringUtils.wrapStringToLength((String)message, (int)30));
            } else {
                currentTipList.add(I18n.func_135052_a((String)"tooltip.powersuits.installedModules", (Object[])new Object[0]));
                for (String moduleName : installed) {
                    currentTipList.add(MuseStringUtils.wrapFormatTags((String)moduleName, (MuseStringUtils.FormatCodes)MuseStringUtils.FormatCodes.Indigo));
                }
            }
        } else {
            currentTipList.add(MuseCommonStrings.additionalInfoInstructions());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String additionalInfoInstructions() {
        String message = I18n.func_135052_a((String)"tooltip.powersuits.pressShift", (Object[])new Object[0]);
        return MuseStringUtils.wrapMultipleFormatTags((String)message, (Object[])new Object[]{MuseStringUtils.FormatCodes.Grey, MuseStringUtils.FormatCodes.Italic});
    }

    public static double getOrSetModuleProperty(NBTTagCompound moduleTag, String propertyName, double defaultValue) {
        if (!moduleTag.func_74764_b(propertyName)) {
            moduleTag.func_74780_a(propertyName, defaultValue);
        }
        return moduleTag.func_74769_h(propertyName);
    }

    public static List<String> getItemInstalledModules(EntityPlayer player, ItemStack stack) {
        NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag((ItemStack)stack);
        LinkedList<String> modules = new LinkedList<String>();
        for (IPowerModule module : ModuleManager.INSTANCE.getValidModulesForItem(stack)) {
            if (!ModuleManager.INSTANCE.tagHasModule(itemTag, module.getDataName())) continue;
            modules.add(I18n.func_135052_a((String)(module.getUnlocalizedName() + ".name"), (Object[])new Object[0]));
        }
        return modules;
    }
}

