/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import java.util.HashMap;
import java.util.Map;
import mekanism.client.render.FluidRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityBoilerCasing;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderThermoelectricBoiler
extends TileEntitySpecialRenderer<TileEntityBoilerCasing> {
    private static Map<FluidRenderer.RenderData, MekanismRenderer.DisplayInteger[]> cachedLowerFluids = new HashMap<FluidRenderer.RenderData, MekanismRenderer.DisplayInteger[]>();
    private static Map<FluidRenderer.RenderData, MekanismRenderer.DisplayInteger> cachedUpperFluids = new HashMap<FluidRenderer.RenderData, MekanismRenderer.DisplayInteger>();
    private static Map<FluidRenderer.ValveRenderData, MekanismRenderer.DisplayInteger> cachedValveFluids = new HashMap<FluidRenderer.ValveRenderData, MekanismRenderer.DisplayInteger>();
    private FluidStack STEAM = new FluidStack(FluidRegistry.getFluid((String)"steam"), 1);
    private FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1);

    public void render(TileEntityBoilerCasing tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tileEntity.clientHasStructure && tileEntity.isRendering && tileEntity.structure != null && ((SynchronizedBoilerData)tileEntity.structure).renderLocation != null && ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation != null) {
            FluidRenderer.RenderData data;
            if (((SynchronizedBoilerData)tileEntity.structure).waterStored != null && ((SynchronizedBoilerData)tileEntity.structure).waterStored.amount != 0) {
                data = new FluidRenderer.RenderData();
                data.location = ((SynchronizedBoilerData)tileEntity.structure).renderLocation;
                data.height = ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation.y - 1 - ((SynchronizedBoilerData)tileEntity.structure).renderLocation.y;
                data.length = ((SynchronizedBoilerData)tileEntity.structure).volLength;
                data.width = ((SynchronizedBoilerData)tileEntity.structure).volWidth;
                data.fluidType = this.WATER;
                this.func_147499_a(MekanismRenderer.getBlocksTexture());
                if (data.height >= 1 && ((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid() != null) {
                    FluidRenderer.push();
                    FluidRenderer.translateToOrigin(data.location);
                    MekanismRenderer.glowOn(((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid().getLuminosity());
                    MekanismRenderer.colorFluid(((SynchronizedBoilerData)tileEntity.structure).waterStored);
                    if (((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid().isGaseous()) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)((SynchronizedBoilerData)tileEntity.structure).waterStored.amount / (float)tileEntity.clientWaterCapacity + MekanismRenderer.GAS_RENDER_BASE));
                        FluidRenderer.getTankDisplay(data).render();
                    } else {
                        FluidRenderer.getTankDisplay(data, tileEntity.prevWaterScale).render();
                    }
                    MekanismRenderer.glowOff();
                    MekanismRenderer.resetColor();
                    FluidRenderer.pop();
                    for (SynchronizedTankData.ValveData valveData : tileEntity.valveViewing) {
                        FluidRenderer.push();
                        FluidRenderer.translateToOrigin(valveData.location);
                        MekanismRenderer.glowOn(((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid().getLuminosity());
                        FluidRenderer.getValveDisplay(FluidRenderer.ValveRenderData.get(data, valveData)).render();
                        MekanismRenderer.glowOff();
                        MekanismRenderer.resetColor();
                        FluidRenderer.pop();
                    }
                }
            }
            if (((SynchronizedBoilerData)tileEntity.structure).steamStored != null && ((SynchronizedBoilerData)tileEntity.structure).steamStored.amount > 0) {
                data = new FluidRenderer.RenderData();
                data.location = ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation;
                data.height = ((SynchronizedBoilerData)tileEntity.structure).renderLocation.y + ((SynchronizedBoilerData)tileEntity.structure).volHeight - 2 - ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation.y;
                data.length = ((SynchronizedBoilerData)tileEntity.structure).volLength;
                data.width = ((SynchronizedBoilerData)tileEntity.structure).volWidth;
                data.fluidType = this.STEAM;
                this.func_147499_a(MekanismRenderer.getBlocksTexture());
                if (data.height >= 1 && ((SynchronizedBoilerData)tileEntity.structure).steamStored.getFluid() != null) {
                    FluidRenderer.push();
                    FluidRenderer.translateToOrigin(data.location);
                    MekanismRenderer.glowOn(((SynchronizedBoilerData)tileEntity.structure).steamStored.getFluid().getLuminosity());
                    MekanismRenderer.colorFluid(((SynchronizedBoilerData)tileEntity.structure).steamStored);
                    MekanismRenderer.DisplayInteger display = FluidRenderer.getTankDisplay(data);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)((SynchronizedBoilerData)tileEntity.structure).steamStored.amount / (float)tileEntity.clientSteamCapacity + MekanismRenderer.GAS_RENDER_BASE));
                    display.render();
                    MekanismRenderer.glowOff();
                    MekanismRenderer.resetColor();
                    FluidRenderer.pop();
                }
            }
        }
    }

    private int getStages(int height) {
        return height * 6400;
    }
}

