/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot.elements;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.elements.ISprite;
import reborncore.client.gui.builder.slot.elements.OffsetSprite;
import reborncore.client.gui.builder.slot.elements.Sprite;
import reborncore.client.gui.builder.slot.elements.SpriteContainer;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.tile.TileLegacyMachineBase;

public class ElementBase {
    public int x;
    public int y;
    public boolean isHovering = false;
    public boolean isDragging = false;
    public boolean isPressing = false;
    public boolean isReleasing = false;
    public boolean startPressLast = false;
    public boolean isHoveringLast = false;
    public boolean isDraggingLast = false;
    public boolean isPressingLast = false;
    public boolean isReleasingLast = false;
    public List<Action> hoverActions = new ArrayList<Action>();
    public List<Action> dragActions = new ArrayList<Action>();
    public List<Action> startPressActions = new ArrayList<Action>();
    public List<Action> pressActions = new ArrayList<Action>();
    public List<Action> releaseActions = new ArrayList<Action>();
    public SpriteContainer container;
    public List<UpdateAction> updateActions = new ArrayList<UpdateAction>();
    public List<UpdateAction> buttonUpdate = new ArrayList<UpdateAction>();
    private int width;
    private int height;
    public static final ResourceLocation MECH_ELEMENTS = new ResourceLocation("reborncore", "textures/gui/elements.png");

    public ElementBase(int x, int y, SpriteContainer container) {
        this.container = container;
        this.x = x;
        this.y = y;
    }

    public ElementBase(int x, int y, ISprite ... sprites) {
        this.container = new SpriteContainer();
        for (ISprite sprite : sprites) {
            this.container.addSprite(sprite);
        }
        this.x = x;
        this.y = y;
    }

    public ElementBase(int x, int y, int width, int height) {
        this.container = new SpriteContainer();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ElementBase(int x, int y, int width, int height, SpriteContainer container) {
        this.container = container;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ElementBase(int x, int y, int width, int height, ISprite ... sprites) {
        this.container = new SpriteContainer();
        for (ISprite sprite : sprites) {
            this.container.addSprite(sprite);
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public SpriteContainer getSpriteContainer() {
        return this.container;
    }

    public void adjustDimensions(TileLegacyMachineBase provider) {
        if (this.container.offsetSprites != null) {
            for (OffsetSprite offsetSprite : this.container.offsetSprites) {
                if (offsetSprite.getSprite().getSprite((TileLegacyMachineBase)provider).width + offsetSprite.getOffsetX(provider) > this.width) {
                    this.width = offsetSprite.getSprite().getSprite((TileLegacyMachineBase)provider).width + offsetSprite.getOffsetX(provider);
                }
                if (offsetSprite.getSprite().getSprite((TileLegacyMachineBase)provider).height + offsetSprite.getOffsetY(provider) <= this.height) continue;
                this.height = offsetSprite.getSprite().getSprite((TileLegacyMachineBase)provider).height + offsetSprite.getOffsetY(provider);
            }
        }
    }

    public void draw(GuiBase gui) {
        for (OffsetSprite sprite : this.getSpriteContainer().offsetSprites) {
            this.drawSprite(gui, sprite.getSprite(), this.x + sprite.getOffsetX(gui.getMachine()), this.y + sprite.getOffsetY(gui.getMachine()));
        }
    }

    public void renderUpdate(GuiBase gui) {
        this.isHoveringLast = this.isHovering;
        this.isPressingLast = this.isPressing;
        this.isDraggingLast = this.isDragging;
        this.isReleasingLast = this.isReleasing;
    }

    public void update(GuiBase gui) {
        for (UpdateAction action : this.updateActions) {
            action.update(gui, this);
        }
    }

    public ElementBase addUpdateAction(UpdateAction action) {
        this.updateActions.add(action);
        return this;
    }

    public ElementBase setWidth(int width) {
        this.width = width;
        return this;
    }

    public ElementBase setHeight(int height) {
        this.height = height;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public ElementBase setX(int x) {
        this.x = x;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public ElementBase setY(int y) {
        this.y = y;
        return this;
    }

    public int getWidth(TileLegacyMachineBase provider) {
        this.adjustDimensions(provider);
        return this.width;
    }

    public int getHeight(TileLegacyMachineBase provider) {
        this.adjustDimensions(provider);
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ElementBase addHoverAction(Action action) {
        this.hoverActions.add(action);
        return this;
    }

    public ElementBase addDragAction(Action action) {
        this.dragActions.add(action);
        return this;
    }

    public ElementBase addStartPressAction(Action action) {
        this.startPressActions.add(action);
        return this;
    }

    public ElementBase addPressAction(Action action) {
        this.pressActions.add(action);
        return this;
    }

    public ElementBase addReleaseAction(Action action) {
        this.releaseActions.add(action);
        return this;
    }

    public boolean onHover(TileLegacyMachineBase provider, GuiBase gui, int mouseX, int mouseY) {
        for (Action action : this.hoverActions) {
            action.execute(this, gui, provider, mouseX, mouseY);
        }
        return !this.hoverActions.isEmpty();
    }

    public boolean onDrag(TileLegacyMachineBase provider, GuiBase gui, int mouseX, int mouseY) {
        for (Action action : this.dragActions) {
            action.execute(this, gui, provider, mouseX, mouseY);
        }
        return !this.dragActions.isEmpty();
    }

    public boolean onStartPress(TileLegacyMachineBase provider, GuiBase gui, int mouseX, int mouseY) {
        for (Action action : this.startPressActions) {
            action.execute(this, gui, provider, mouseX, mouseY);
        }
        return !this.startPressActions.isEmpty();
    }

    public boolean onRelease(TileLegacyMachineBase provider, GuiBase gui, int mouseX, int mouseY) {
        for (Action action : this.releaseActions) {
            if (!action.execute(this, gui, provider, mouseX, mouseY)) continue;
            return true;
        }
        if (this.isPressing) {
            for (Action action : this.pressActions) {
                action.execute(this, gui, provider, mouseX, mouseY);
            }
        }
        return !this.releaseActions.isEmpty() || !this.pressActions.isEmpty();
    }

    public void drawRect(GuiBase gui, int x, int y, int width, int height, int colour) {
        this.drawGradientRect(gui, x, y, width, height, colour, colour);
    }

    public void drawGradientRect(GuiBase gui, int x, int y, int width, int height, int startColor, int endColor) {
        x = this.adjustX(gui, x);
        y = this.adjustY(gui, y);
        int left = x;
        int top = y;
        int right = x + width;
        int bottom = y + height;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public int adjustX(GuiBase gui, int x) {
        return gui.field_147003_i + x;
    }

    public int adjustY(GuiBase gui, int y) {
        return gui.field_147009_r + y;
    }

    public boolean isInRect(GuiBase gui, int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return gui.isPointInRect(x + gui.field_147003_i, y + gui.field_147009_r, xSize, ySize, mouseX, mouseY);
    }

    public void drawString(GuiBase gui, String string, int x, int y, int color) {
        x = this.adjustX(gui, x);
        y = this.adjustY(gui, y);
        gui.field_146297_k.field_71466_p.func_78276_b(string, x, y, color);
    }

    public void drawString(GuiBase gui, String string, int x, int y) {
        this.drawString(gui, string, x, y, 0xFFFFFF);
    }

    public void setTextureSheet(ResourceLocation textureLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureLocation);
    }

    public void drawCenteredString(GuiBase gui, String string, int y, int colour) {
        this.drawString(gui, string, gui.getXSize() / 2 - gui.field_146297_k.field_71466_p.func_78256_a(string) / 2, y, colour);
    }

    public void drawCenteredString(GuiBase gui, String string, int x, int y, int colour) {
        this.drawString(gui, string, x - gui.field_146297_k.field_71466_p.func_78256_a(string) / 2, y, colour);
    }

    public int getStringWidth(String string) {
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(string);
    }

    public void drawSprite(GuiBase gui, ISprite iSprite, int x, int y) {
        Sprite sprite = iSprite.getSprite(gui.getMachine());
        if (sprite != null) {
            if (sprite.hasTextureInfo()) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                this.setTextureSheet(sprite.textureLocation);
                gui.func_73729_b(x + gui.field_147003_i, y + gui.field_147009_r, sprite.x, sprite.y, sprite.width, sprite.height);
            }
            if (sprite.hasStack()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderHelper.func_74520_c();
                RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
                itemRenderer.func_180450_b(sprite.itemStack, x + gui.field_147003_i, y + gui.field_147009_r);
                GlStateManager.func_179140_f();
                GlStateManager.func_179121_F();
            }
        }
    }

    public int getScaledBurnTime(int scale, int burnTime, int totalBurnTime) {
        return (int)((float)burnTime / (float)totalBurnTime * (float)scale);
    }

    public int getPercentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    public void drawDefaultBackground(GuiScreen gui, int x, int y, int width, int height) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBuilder.defaultTextureSheet);
        gui.func_73729_b(x, y, 0, 0, width / 2, height / 2);
        gui.func_73729_b(x + width / 2, y, 150 - width / 2, 0, width / 2, height / 2);
        gui.func_73729_b(x, y + height / 2, 0, 150 - height / 2, width / 2, height / 2);
        gui.func_73729_b(x + width / 2, y + height / 2, 150 - width / 2, 150 - height / 2, width / 2, height / 2);
    }

    public static interface UpdateAction {
        public void update(GuiBase var1, ElementBase var2);
    }

    public static interface Action {
        public boolean execute(ElementBase var1, GuiBase var2, TileLegacyMachineBase var3, int var4, int var5);
    }
}

