/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CubeObject {
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public CubeObject(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public CubeObject(AxisAlignedBB box) {
        this((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72337_e, (float)box.field_72334_f);
    }

    public CubeObject() {
        this(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public CubeObject(CubeObject cube) {
        this(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ, cube);
    }

    public CubeObject(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, CubeObject cube) {
        this(minX, minY, minZ, maxX, maxY, maxZ);
        this.applyExtraCubeData(cube);
    }

    protected void applyExtraCubeData(CubeObject cube) {
    }

    public void add(Vec3d vec) {
        this.minX = (float)((double)this.minX + vec.field_72450_a);
        this.minY = (float)((double)this.minY + vec.field_72448_b);
        this.minZ = (float)((double)this.minZ + vec.field_72449_c);
        this.maxX = (float)((double)this.maxX + vec.field_72450_a);
        this.maxY = (float)((double)this.maxY + vec.field_72448_b);
        this.maxZ = (float)((double)this.maxZ + vec.field_72449_c);
    }

    public void sub(Vec3d vec) {
        this.minX = (float)((double)this.minX - vec.field_72450_a);
        this.minY = (float)((double)this.minY - vec.field_72448_b);
        this.minZ = (float)((double)this.minZ - vec.field_72449_c);
        this.maxX = (float)((double)this.maxX - vec.field_72450_a);
        this.maxY = (float)((double)this.maxY - vec.field_72448_b);
        this.maxZ = (float)((double)this.maxZ - vec.field_72449_c);
    }

    public Vec3d getSize() {
        return new Vec3d((double)(this.maxX - this.minX), (double)(this.maxY - this.minY), (double)(this.maxZ - this.minZ));
    }

    public String toString() {
        return "cube[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public AxisAlignedBB getAxis() {
        return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public void rotate(Rotation rotation, Vector3f center) {
        Vector3f low = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f high = new Vector3f(this.maxX, this.maxY, this.maxZ);
        low.sub((Tuple3f)center);
        high.sub((Tuple3f)center);
        rotation.getMatrix().transform((Tuple3f)low);
        rotation.getMatrix().transform((Tuple3f)high);
        low.add((Tuple3f)center);
        high.add((Tuple3f)center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void rotate(EnumFacing facing, Vector3f center) {
        Matrix3f matrix = new Matrix3f();
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            facing = facing.func_176734_d();
        }
        matrix.rotY((float)Math.toRadians(facing.func_185119_l()));
        this.rotate(matrix, center);
    }

    public void rotate(Matrix3f matrix, Vector3f center) {
        Vector3f low = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f high = new Vector3f(this.maxX, this.maxY, this.maxZ);
        low.sub((Tuple3f)center);
        high.sub((Tuple3f)center);
        matrix.transform((Tuple3f)low);
        matrix.transform((Tuple3f)high);
        low.add((Tuple3f)center);
        high.add((Tuple3f)center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void set(float x, float y, float z, float x2, float y2, float z2) {
        this.minX = Math.min(x, x2);
        this.minY = Math.min(y, y2);
        this.minZ = Math.min(z, z2);
        this.maxX = Math.max(x, x2);
        this.maxY = Math.max(y, y2);
        this.maxZ = Math.max(z, z2);
    }

    public BlockPos getOffset() {
        return new BlockPos((double)this.minX, (double)this.minY, (double)this.minZ);
    }

    public CubeObject offset(BlockPos pos) {
        return new CubeObject(this.minX - (float)pos.func_177958_n(), this.minY - (float)pos.func_177956_o(), this.minZ - (float)pos.func_177952_p(), this.maxX - (float)pos.func_177958_n(), this.maxY - (float)pos.func_177956_o(), this.maxZ - (float)pos.func_177952_p(), this);
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3f get(EnumFaceDirection.VertexInformation info, Vector3f output) {
        output.set(this.getVertexInformationPosition(info.field_179184_a), this.getVertexInformationPosition(info.field_179182_b), this.getVertexInformationPosition(info.field_179183_c));
        return output;
    }

    public float getVertexInformationPositionOffset(int index, Vec3i pos) {
        return this.getVertexInformationPosition(index) - (float)RotationUtils.get(EnumFacing.func_82600_a((int)index).func_176740_k(), pos);
    }

    public float getVertexInformationPosition(int index) {
        switch (EnumFacing.func_82600_a((int)index)) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public float getValueOfFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public float getSize(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX - this.minX;
            }
            case Y: {
                return this.maxY - this.minY;
            }
            case Z: {
                return this.maxZ - this.minZ;
            }
        }
        return 0.0f;
    }

    public void setMin(EnumFacing.Axis axis, float value) {
        switch (axis) {
            case X: {
                this.minX = value;
                break;
            }
            case Y: {
                this.minY = value;
                break;
            }
            case Z: {
                this.minZ = value;
            }
        }
    }

    public float getMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public void setMax(EnumFacing.Axis axis, float value) {
        switch (axis) {
            case X: {
                this.maxX = value;
                break;
            }
            case Y: {
                this.maxY = value;
                break;
            }
            case Z: {
                this.maxZ = value;
            }
        }
    }

    public float getMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0.0f;
    }

    public static CubeObject rotateCube(CubeObject cube, EnumFacing direction) {
        return CubeObject.rotateCube(cube, direction, new Vec3d(0.5, 0.5, 0.5));
    }

    public static CubeObject rotateCube(CubeObject cube, EnumFacing direction, Vec3d center) {
        CubeObject rotateCube = new CubeObject(cube);
        CubeObject.applyCubeRotation(rotateCube, direction, center);
        return rotateCube;
    }

    public static Vec3d applyVectorRotation(Vec3d vector, EnumFacing EnumFacing2) {
        double tempX = vector.field_72450_a;
        double tempY = vector.field_72448_b;
        double tempZ = vector.field_72449_c;
        double posX = tempX;
        double posY = tempY;
        double posZ = tempZ;
        switch (EnumFacing2) {
            case UP: {
                posX = -tempY;
                posY = tempX;
                break;
            }
            case DOWN: {
                posX = tempY;
                posY = -tempX;
                break;
            }
            case SOUTH: {
                posX = -tempZ;
                posZ = tempX;
                break;
            }
            case NORTH: {
                posX = tempZ;
                posZ = -tempX;
                break;
            }
            case WEST: {
                posX = -tempX;
                posZ = -tempZ;
                break;
            }
        }
        return new Vec3d(posX, posY, posZ);
    }

    public static void applyCubeRotation(CubeObject cube, EnumFacing EnumFacing2) {
        CubeObject.applyCubeRotation(cube, EnumFacing2, new Vec3d(0.5, 0.5, 0.5));
    }

    public static void applyCubeRotation(CubeObject cube, EnumFacing EnumFacing2, Vec3d center) {
        float minX = cube.minX;
        float minY = cube.minY;
        float minZ = cube.minZ;
        float maxX = cube.maxX;
        float maxY = cube.maxY;
        float maxZ = cube.maxZ;
        if (center != null) {
            minX = (float)((double)minX - center.field_72450_a);
            minY = (float)((double)minY - center.field_72448_b);
            minZ = (float)((double)minZ - center.field_72449_c);
            maxX = (float)((double)maxX - center.field_72450_a);
            maxY = (float)((double)maxY - center.field_72448_b);
            maxZ = (float)((double)maxZ - center.field_72449_c);
        }
        Vec3d min = CubeObject.applyVectorRotation(new Vec3d((double)minX, (double)minY, (double)minZ), EnumFacing2);
        Vec3d max = CubeObject.applyVectorRotation(new Vec3d((double)maxX, (double)maxY, (double)maxZ), EnumFacing2);
        if (center != null) {
            min = min.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            max = max.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        }
        if (min.field_72450_a < max.field_72450_a) {
            cube.minX = (float)min.field_72450_a;
            cube.maxX = (float)max.field_72450_a;
        } else {
            cube.minX = (float)max.field_72450_a;
            cube.maxX = (float)min.field_72450_a;
        }
        if (min.field_72448_b < max.field_72448_b) {
            cube.minY = (float)min.field_72448_b;
            cube.maxY = (float)max.field_72448_b;
        } else {
            cube.minY = (float)max.field_72448_b;
            cube.maxY = (float)min.field_72448_b;
        }
        if (min.field_72449_c < max.field_72449_c) {
            cube.minZ = (float)min.field_72449_c;
            cube.maxZ = (float)max.field_72449_c;
        } else {
            cube.minZ = (float)max.field_72449_c;
            cube.maxZ = (float)min.field_72449_c;
        }
    }
}

