/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.type;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class PairList<K, V>
extends ArrayList<Pair<K, V>> {
    protected HashMap<K, Integer> keyIndex = new HashMap();
    protected List<V> values = new ArrayList<V>();

    public PairList() {
    }

    public PairList(List<Pair<K, V>> list) {
        super(list);
        this.updateEntireMap();
    }

    protected void updateEntireMap() {
        this.keyIndex.clear();
        this.values.clear();
        for (int i = 0; i < this.size(); ++i) {
            this.keyIndex.put(((Pair)this.get((int)i)).key, i);
            this.values.add(((Pair)this.get((int)i)).value);
        }
    }

    @Override
    public boolean add(Pair<K, V> e) {
        Objects.requireNonNull(e);
        if (this.keyIndex.containsKey(e.key)) {
            throw new IllegalArgumentException("Duplicates are not allowed key: " + e.key);
        }
        if (super.add(e)) {
            this.keyIndex.put(e.key, this.size() - 1);
            this.values.add(e.value);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, Pair<K, V> element) {
        Objects.requireNonNull(element);
        if (this.keyIndex.containsKey(element.key)) {
            throw new IllegalArgumentException("Duplicates are not allowed key: " + element.key);
        }
        super.add(index, element);
        this.updateEntireMap();
    }

    @Override
    public boolean addAll(Collection<? extends Pair<K, V>> c) {
        Objects.requireNonNull(c);
        for (Pair<K, V> pair : c) {
            Objects.requireNonNull(pair);
            if (!this.keyIndex.containsKey(pair.key)) continue;
            throw new IllegalArgumentException("Duplicates are not allowed key: " + pair.key);
        }
        int sizeBefore = this.size();
        if (super.addAll(c)) {
            for (int i = 0; i < c.size(); ++i) {
                int index = sizeBefore + i;
                this.keyIndex.put(((Pair)this.get((int)index)).key, index);
                this.values.add(((Pair)this.get((int)index)).value);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Pair<K, V>> c) {
        Objects.requireNonNull(c);
        for (Pair<K, V> pair : c) {
            Objects.requireNonNull(pair);
            if (!this.keyIndex.containsKey(pair.key)) continue;
            throw new IllegalArgumentException("Duplicates are not allowed key: " + pair.key);
        }
        if (super.addAll(index, c)) {
            this.updateEntireMap();
            return true;
        }
        return false;
    }

    public boolean add(K key, V value) {
        return this.add(new Pair<K, V>(key, value));
    }

    public void set(K key, V value) {
        Pair<K, V> pair = this.getPair(key);
        if (pair != null) {
            pair.value = value;
        }
    }

    @Override
    public Pair<K, V> remove(int index) {
        Pair pair = (Pair)super.remove(index);
        if (pair != null) {
            this.updateEntireMap();
            return pair;
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.updateEntireMap();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (super.removeAll(c)) {
            this.updateEntireMap();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super Pair<K, V>> filter) {
        if (super.removeIf(filter)) {
            this.updateEntireMap();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (super.retainAll(c)) {
            this.updateEntireMap();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.keyIndex.clear();
        this.values.clear();
    }

    @Override
    public Pair<K, V> set(int index, Pair<K, V> element) {
        Objects.requireNonNull(element);
        Integer exisiting = this.keyIndex.get(element.key);
        if (exisiting != null && exisiting != index) {
            throw new IllegalArgumentException("Duplicates are not allowed key: " + element.key);
        }
        Pair<K, V> old = super.set(index, element);
        if (old != null) {
            this.keyIndex.remove(old.key);
            this.keyIndex.put(element.key, index);
            this.values.set(index, element.value);
        }
        return old;
    }

    @Override
    public void sort(Comparator<? super Pair<K, V>> c) {
        super.sort(c);
        this.updateEntireMap();
    }

    public boolean containsKey(K key) {
        return this.keyIndex.containsKey(key);
    }

    public int indexOfKey(K key) {
        return this.keyIndex.getOrDefault(key, -1);
    }

    public boolean removeKey(K key) {
        Integer index = this.keyIndex.get(key);
        if (index != null) {
            return this.remove(index) != null;
        }
        return false;
    }

    public List<V> values() {
        return ImmutableList.copyOf(this.values);
    }

    public Set<K> keys() {
        return this.keyIndex.keySet();
    }

    @Override
    public Pair<K, V> getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (Pair)this.get(0);
    }

    @Override
    public Pair<K, V> getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return (Pair)this.get(this.size() - 1);
    }

    @Nullable
    public V getValue(K key) {
        Integer index = this.keyIndex.get(key);
        if (index != null) {
            return ((Pair)this.get((int)index.intValue())).value;
        }
        return null;
    }

    @Nullable
    public Pair<K, V> getPair(K key) {
        Integer index = this.keyIndex.get(key);
        if (index != null) {
            return (Pair)this.get(index);
        }
        return null;
    }
}

