/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.syncer.handlers;

import net.malisis.core.util.DoubleKeyMap;
import net.malisis.core.util.syncer.ISyncHandler;
import net.malisis.core.util.syncer.ISyncableData;
import net.malisis.core.util.syncer.ObjectData;

public abstract class DefaultSyncHandler<T, S extends ISyncableData>
implements ISyncHandler<T, S> {
    private DoubleKeyMap<String, ObjectData> objectDatas = new DoubleKeyMap();

    @Override
    public void addObjectData(ObjectData objectData) {
        if (this.objectDatas.get(objectData.getName()) != null) {
            throw new RuntimeException(objectData.getName() + " is already registered");
        }
        objectData.setIndex(this.objectDatas.put(objectData.getName(), objectData));
    }

    @Override
    public ObjectData getObjectData(int index) {
        return this.objectDatas.get((String)index);
    }

    @Override
    public ObjectData getObjectData(String name) {
        return this.objectDatas.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (DoubleKeyMap.DoubleKeyEntry<String, ObjectData> doubleKeyEntry : this.objectDatas) {
            sb.append(doubleKeyEntry.getIndex() + ":" + doubleKeyEntry.getKey() + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

