/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import omtteam.omlib.api.network.IController;
import omtteam.omlib.api.network.INameController;
import omtteam.omlib.api.network.INetworkTile;
import omtteam.omlib.api.network.IPowerExchangeTile;
import omtteam.omlib.handler.OMLibEventHandler;
import omtteam.omlib.util.player.Player;

public class OMLibNetwork {
    private Map<BlockPos, INetworkTile> devices = new HashMap<BlockPos, INetworkTile>();
    private World world;
    private UUID uuid;
    private String name;
    private Player owner;

    public OMLibNetwork(World world) {
        this.world = world;
        this.uuid = UUID.randomUUID();
        OMLibEventHandler.getInstance().registerNetwork(this);
    }

    public OMLibNetwork(World world, String name) {
        this.world = world;
        this.uuid = UUID.randomUUID();
        this.name = name;
        OMLibEventHandler.getInstance().registerNetwork(this);
    }

    public void tick() {
        ArrayList<IPowerExchangeTile> delivering = new ArrayList<IPowerExchangeTile>();
        ArrayList<IPowerExchangeTile> requiring = new ArrayList<IPowerExchangeTile>();
        int powerRequired = 0;
        int powerToDeliver = 0;
        for (Map.Entry<BlockPos, INetworkTile> device : this.devices.entrySet()) {
            if (!this.world.func_175667_e(device.getKey()) || !(device.getValue() instanceof IPowerExchangeTile)) continue;
            if (((IPowerExchangeTile)device.getValue()).deliversEnergy()) {
                delivering.add((IPowerExchangeTile)device.getValue());
                continue;
            }
            if (!((IPowerExchangeTile)device.getValue()).requiresEnergy()) continue;
            requiring.add((IPowerExchangeTile)device.getValue());
        }
        for (IPowerExchangeTile tile : requiring) {
            powerRequired += Math.min(tile.getEnergyStorage().getMaxReceive(), tile.getEnergyStorage().getMaxEnergyStored() - tile.getEnergyStorage().getEnergyStored());
        }
        for (IPowerExchangeTile tile : delivering) {
            powerToDeliver += Math.min(powerRequired - powerToDeliver, Math.min(tile.getEnergyStorage().getMaxExtract(), tile.getEnergyStorage().getMaxEnergyStored() - tile.getEnergyStorage().getEnergyStored()));
        }
        for (IPowerExchangeTile tile : requiring) {
            tile.getEnergyStorage().receiveEnergy(powerToDeliver / requiring.size(), false);
            powerToDeliver -= powerToDeliver / requiring.size();
        }
    }

    @Nullable
    public <T> T getController(Class<T> clazz) {
        for (INetworkTile device : this.devices.values()) {
            if (!clazz.isInstance(device) || !(device instanceof IController)) continue;
            return (T)device;
        }
        return null;
    }

    public boolean addDevice(INetworkTile tile) {
        boolean controllerExists;
        boolean bl = controllerExists = this.getController(tile.getClass()) != null;
        if (!controllerExists) {
            this.devices.putIfAbsent(tile.getPosition(), tile);
            if (tile instanceof INameController) {
                this.setName(((INameController)((Object)tile)).getNetworkName());
            }
            return true;
        }
        return false;
    }

    public boolean removeDevice(INetworkTile tile) {
        return this.devices.remove(tile.getPosition()) != null;
    }

    @Nullable
    public INetworkTile getConnectedDevice(BlockPos pos) {
        return this.world.func_175667_e(pos) ? this.devices.get(pos) : null;
    }

    public Collection<INetworkTile> getAllDevices() {
        return this.devices.values();
    }

    public World getWorld() {
        return this.world;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    private boolean isSplitted() {
        HashMap<BlockPos, INetworkTile> tempmap = new HashMap<BlockPos, INetworkTile>();
        this.recursiveSearch((BlockPos)this.devices.keySet().toArray()[0], null, tempmap);
        return tempmap.keySet().equals(this.devices.keySet());
    }

    private void recursiveSearch(BlockPos pos, @Nullable EnumFacing from, HashMap<BlockPos, INetworkTile> tempmap) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = this.world.func_175625_s(pos.func_177972_a(facing));
            if (facing.equals((Object)from) || !(te instanceof INetworkTile & te != null)) continue;
            tempmap.put(pos.func_177972_a(facing), (INetworkTile)te);
            this.recursiveSearch(pos.func_177972_a(facing), facing.func_176734_d(), tempmap);
        }
    }

    public void splitNetwork() {
        if (this.isSplitted()) {
            for (INetworkTile tile : this.devices.values()) {
                tile.setNetwork(null);
            }
        }
    }

    public void mergeNetwork(OMLibNetwork network) {
        for (INetworkTile tile : network.getAllDevices()) {
            this.devices.putIfAbsent(tile.getPosition(), tile);
            tile.setNetwork(this);
        }
        network.destroy();
    }

    public NBTTagCompound getAsNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("uuid", this.uuid);
        tag.func_74778_a("name", this.name);
        return tag;
    }

    public UUID getUuidFromTagCompound(NBTTagCompound tag) {
        return tag.func_186857_a("uuid");
    }

    private void destroy() {
        OMLibEventHandler.getInstance().removeNetwork(this);
        this.devices = null;
        this.world = null;
    }
}

