/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.varia.EntityTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.config.GeneralConfiguration;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.ModItems;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SyringeItem
extends GenericRFToolsItem {
    public SyringeItem() {
        super("syringe");
        this.func_77625_d(1);
        this.func_77642_a(this);
    }

    public boolean hasContainerItem(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return tagCompound != null && tagCompound.func_74762_e("level") > 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (EntityEntry entry : ForgeRegistries.ENTITIES) {
                Class clazz = entry.getEntityClass();
                if (!EntityLiving.class.isAssignableFrom(clazz)) continue;
                items.add((Object)SyringeItem.createMobSyringe(clazz));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 5; ++i) {
            String domain = this.getRegistryName().func_110624_b();
            String path = this.getRegistryName().func_110623_a();
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation(domain, path + i), "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound tagCompound = stack.func_77978_p();
            int level = 0;
            if (tagCompound != null) {
                level = tagCompound.func_74762_e("level");
            }
            level = level <= 0 ? 0 : (level >= GeneralConfiguration.maxMobInjections.get() ? 5 : (level - 1) * 4 / (GeneralConfiguration.maxMobInjections.get() - 1) + 1);
            String domain = this.getRegistryName().func_110624_b();
            String path = this.getRegistryName().func_110623_a();
            return new ModelResourceLocation(new ResourceLocation(domain, path + level), "inventory");
        });
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                String mobName = SyringeItem.getMobName(stack);
                if (mobName != null) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.BLUE + "Mob: " + mobName));
                }
                int level = tagCompound.func_74762_e("level");
                level = level * 100 / GeneralConfiguration.maxMobInjections.get();
                Logging.message((EntityPlayer)player, (String)(TextFormatting.BLUE + "Essence level: " + level + "%"));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        EntityLiving entityLiving = SyringeItem.getEntityLivingFromClickedEntity(entity);
        if (entityLiving != null) {
            String prevMobId = null;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                prevMobId = EntityTools.fixEntityId((String)tagCompound.func_74779_i("mobId"));
            } else {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            String id = this.findSelectedMobId((Entity)entityLiving);
            if (id != null && !id.isEmpty()) {
                if (!id.equals(prevMobId)) {
                    tagCompound.func_74778_a("mobName", entityLiving.func_70005_c_());
                    tagCompound.func_74778_a("mobId", id);
                    tagCompound.func_74768_a("level", 1);
                } else {
                    tagCompound.func_74768_a("level", Math.min(tagCompound.func_74762_e("level") + 1, GeneralConfiguration.maxMobInjections.get()));
                }
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Nullable
    private static EntityLiving getEntityLivingFromClickedEntity(Entity entity) {
        IEntityMultiPart parent;
        if (entity instanceof EntityLiving) {
            return (EntityLiving)entity;
        }
        if (entity instanceof MultiPartEntityPart && (parent = ((MultiPartEntityPart)entity).field_70259_a) instanceof EntityLiving) {
            return (EntityLiving)parent;
        }
        return null;
    }

    private String findSelectedMobId(Entity entity) {
        ResourceLocation key = EntityList.func_191306_a(entity.getClass());
        return key != null ? key.toString() : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String mobName = SyringeItem.getMobName(itemStack);
            if (mobName != null) {
                list.add(TextFormatting.BLUE + "Mob: " + mobName);
            }
            int level = tagCompound.func_74762_e("level");
            level = level * 100 / GeneralConfiguration.maxMobInjections.get();
            list.add(TextFormatting.BLUE + "Essence level: " + level + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Use this to extract essence from mobs");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public static ItemStack createMobSyringe(Class<? extends Entity> mobClass) {
        String id = EntityTools.findEntityIdByClass(mobClass);
        String name = EntityTools.findEntityLocNameByClass(mobClass);
        return SyringeItem.createMobSyringe(id, name);
    }

    private static ItemStack createMobSyringe(String id, String name) {
        ItemStack syringe = new ItemStack((Item)ModItems.syringeItem);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("mobId", id);
        if (name == null || name.isEmpty()) {
            name = id;
        }
        tagCompound.func_74778_a("mobName", name);
        tagCompound.func_74768_a("level", GeneralConfiguration.maxMobInjections.get());
        syringe.func_77982_d(tagCompound);
        return syringe;
    }

    public static String getMobId(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            String mob = tagCompound.func_74779_i("mobId");
            if (mob == null) {
                return tagCompound.func_74779_i("mobName");
            }
            mob = EntityTools.fixEntityId((String)mob);
            return mob;
        }
        return null;
    }

    public static String getMobName(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            String mob = tagCompound.func_74779_i("mobName");
            if (mob == null || "unknown".equals(mob)) {
                if (tagCompound.func_74764_b("mobId")) {
                    String mobId = tagCompound.func_74779_i("mobId");
                    mobId = EntityTools.fixEntityId((String)mobId);
                    return mobId;
                }
                return "?";
            }
            return mob;
        }
        return null;
    }
}

