/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.util;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.GuideBook;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.util.APISetter;
import amerifrance.guideapi.util.LogHelper;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import org.apache.commons.lang3.tuple.Pair;

public class AnnotationHandler {
    public static final List<Pair<Book, IGuideBook>> BOOK_CLASSES = Lists.newArrayList();

    public static void gatherBooks(ASMDataTable dataTable) {
        for (EventPriority priority : EventPriority.values()) {
            for (ASMDataTable.ASMData data : dataTable.getAll(GuideBook.class.getCanonicalName())) {
                try {
                    Book book;
                    Class<?> genericClass = Class.forName(data.getClassName());
                    if (!IGuideBook.class.isAssignableFrom(genericClass)) continue;
                    IGuideBook guideBook = (IGuideBook)genericClass.newInstance();
                    ModAnnotation.EnumHolder holder = (ModAnnotation.EnumHolder)data.getAnnotationInfo().get("priority");
                    EventPriority bookPriority = holder == null ? EventPriority.NORMAL : EventPriority.valueOf((String)holder.getValue());
                    if (priority != bookPriority || (book = guideBook.buildBook()) == null) continue;
                    APISetter.registerBook(book);
                    BOOK_CLASSES.add((Pair<Book, IGuideBook>)Pair.of((Object)book, (Object)guideBook));
                }
                catch (Exception e) {
                    LogHelper.error("Error registering book for class " + data.getClassName());
                    e.printStackTrace();
                }
            }
        }
        APISetter.setIndexedBooks(Lists.newArrayList(GuideAPI.getBooks().values()));
    }
}

