/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BitInventoryFeeder {
    private static final Random itemRand = new Random();
    ArrayList<Integer> seenBits = new ArrayList();
    boolean hasSentMessage = false;
    final EntityPlayer player;
    final World world;

    public BitInventoryFeeder(EntityPlayer p, World w) {
        this.player = p;
        this.world = w;
    }

    public void addItem(EntityItem ei) {
        ItemStack is = ModUtil.nonNull(ei.func_92059_d());
        List<ItemBitBag.BagPos> bags = ItemBitBag.getBags((IInventory)this.player.field_71071_by);
        if (!ModUtil.containsAtLeastOneOf((IInventory)this.player.field_71071_by, is)) {
            ItemStack minSize = is.func_77946_l();
            if (ModUtil.getStackSize(minSize) > minSize.func_77976_d()) {
                ModUtil.setStackSize(minSize, minSize.func_77976_d());
            }
            ModUtil.adjustStackSize(is, -ModUtil.getStackSize(minSize));
            this.player.field_71071_by.func_70441_a(minSize);
            ModUtil.adjustStackSize(is, ModUtil.getStackSize(minSize));
        }
        for (ItemBitBag.BagPos bp : bags) {
            is = bp.inv.insertItem(is);
        }
        if (ModUtil.isEmpty(is)) {
            return;
        }
        ei.func_92058_a(is);
        EntityItemPickupEvent event = new EntityItemPickupEvent(this.player, ei);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            BitInventoryFeeder.spawnItem(this.world, ei);
        } else if (event.getResult() != Event.Result.DENY) {
            is = ei.func_92059_d();
            if (is != null && !this.player.field_71071_by.func_70441_a(is)) {
                ei.func_92058_a(is);
                if (!ChiselsAndBits.getConfig().voidExcessBits) {
                    BitInventoryFeeder.spawnItem(this.world, ei);
                }
            } else if (!ei.func_174814_R()) {
                ei.field_70170_p.func_184148_a((EntityPlayer)null, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((itemRand.nextFloat() - itemRand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            this.player.field_71071_by.func_70296_d();
            if (this.player.field_71069_bz != null) {
                this.player.field_71069_bz.func_75142_b();
            }
        } else {
            BitInventoryFeeder.spawnItem(this.world, ei);
        }
        int blk = ItemChiseledBit.getStackState(is);
        if (ChiselsAndBits.getConfig().voidExcessBits && !this.seenBits.contains(blk) && !this.hasSentMessage) {
            if (!ItemChiseledBit.hasBitSpace(this.player, blk)) {
                this.player.func_145747_a((ITextComponent)new TextComponentTranslation("mod.chiselsandbits.result.void_excess", new Object[0]));
                this.hasSentMessage = true;
            }
            if (!this.seenBits.contains(blk)) {
                this.seenBits.add(blk);
            }
        }
    }

    private static void spawnItem(World world, EntityItem ei) {
        if (world.field_72995_K) {
            return;
        }
        world.func_72838_d((Entity)ei);
    }
}

