/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mod.chiselsandbits.bittank.BlockBitTank;
import mod.chiselsandbits.bittank.TileEntityBitTank;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.MaterialType;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.config.ModConfig;
import mod.chiselsandbits.registry.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class ModBlocks
extends ModRegistry {
    private static String TE_BIT_TANK = "mod.chiselsandbits.TileEntityBitTank";
    private static String TE_CHISELEDBLOCK = "mod.chiselsandbits.TileEntityChiseled";
    private static String TE_CHISELEDBLOCK_TESR = "mod.chiselsandbits.TileEntityChiseled.tesr";
    private final HashMap<Material, BlockChiseled> conversions = new HashMap();
    private final HashMap<Material, Item> itemConversions = new HashMap();
    public final ItemBlock itemBitTank;
    public final BlockBitTank blockBitTank;
    public static final MaterialType[] validMaterials = new MaterialType[]{new MaterialType("wood", Material.field_151575_d), new MaterialType("rock", Material.field_151576_e), new MaterialType("iron", Material.field_151573_f), new MaterialType("cloth", Material.field_151580_n), new MaterialType("ice", Material.field_151588_w), new MaterialType("packedIce", Material.field_151598_x), new MaterialType("clay", Material.field_151571_B), new MaterialType("glass", Material.field_151592_s), new MaterialType("sand", Material.field_151595_p), new MaterialType("ground", Material.field_151578_c), new MaterialType("grass", Material.field_151577_b), new MaterialType("snow", Material.field_151596_z), new MaterialType("fluid", Material.field_151586_h), new MaterialType("leaves", Material.field_151584_j)};

    public ModBlocks(ModConfig config, Side side) {
        GameRegistry.registerTileEntity(TileEntityBlockChiseled.class, (String)TE_CHISELEDBLOCK);
        if (side == Side.CLIENT) {
            GameRegistry.registerTileEntity(TileEntityBlockChiseledTESR.class, (String)TE_CHISELEDBLOCK_TESR);
        } else {
            GameRegistry.registerTileEntity(TileEntityBlockChiseled.TileEntityBlockChiseledDummy.class, (String)TE_CHISELEDBLOCK_TESR);
        }
        if (config.enableBitTank) {
            this.blockBitTank = new BlockBitTank();
            this.itemBitTank = new ItemBlock((Block)this.blockBitTank);
            this.registerBlock(this.blockBitTank, this.itemBitTank, "bittank");
            GameRegistry.registerTileEntity(TileEntityBitTank.class, (String)TE_BIT_TANK);
        } else {
            this.blockBitTank = null;
            this.itemBitTank = null;
        }
        for (MaterialType mat : validMaterials) {
            BlockChiseled blk = new BlockChiseled(mat.type, "chiseled_" + mat.name);
            ItemBlockChiseled item = new ItemBlockChiseled(blk);
            this.getConversions().put(mat.type, blk);
            this.getItemConversions().put(mat.type, (Item)item);
            this.registerBlock(blk, item, blk.name);
        }
    }

    public IBlockState getChiseledDefaultState() {
        Iterator<BlockChiseled> iterator = this.getConversions().values().iterator();
        if (iterator.hasNext()) {
            BlockChiseled bc = iterator.next();
            return bc.func_176223_P();
        }
        return null;
    }

    public BlockChiseled getConversion(IBlockState material) {
        Fluid f = BlockBitInfo.getFluidFromBlock(material.func_177230_c());
        if (f != null) {
            return this.getConversions().get(Material.field_151586_h);
        }
        BlockChiseled out = this.getConversions().get(material.func_185904_a());
        if (out == null) {
            out = this.getConversions().get(Material.field_151576_e);
        }
        return out;
    }

    public BlockChiseled getConversionWithDefault(IBlockState material) {
        Iterator<BlockChiseled> iterator;
        BlockChiseled bcX = this.getConversion(material);
        if (bcX == null && (iterator = this.getConversions().values().iterator()).hasNext()) {
            BlockChiseled bc = iterator.next();
            return bc;
        }
        return bcX;
    }

    public Map<Material, Item> getItemConversions() {
        return this.itemConversions;
    }

    public Map<Material, BlockChiseled> getConversions() {
        return this.conversions;
    }

    public boolean addConversion(Material newMaterial, Material target) {
        BlockChiseled targ = this.conversions.get(target);
        if (targ != null && !this.conversions.containsKey(newMaterial)) {
            BlockBitInfo.reset();
            this.conversions.put(newMaterial, targ);
            return true;
        }
        return false;
    }
}

