/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.managers;

import ic2.api.classic.recipe.machine.IMachineFilter;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.IRecyclerRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.core.block.machine.recipes.entries.ScrapMetalOutput;
import ic2.core.block.machine.recipes.entries.ScrapOutput;
import ic2.core.block.machine.recipes.managers.BasicMachineFilter;
import ic2.core.block.machine.recipes.managers.BasicMachineRecipeList;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecyclerRecipeList
extends BasicMachineRecipeList
implements IRecyclerRecipeList {
    public IMachineFilter filter;
    public MachineOutput scrap;
    public MachineOutput scrapMetal;
    private Set<Integer> metalIDs = new HashSet<Integer>();

    public RecyclerRecipeList() {
        super("recycler");
        this.filter = new BasicMachineFilter();
        this.scrap = new ScrapOutput();
        this.scrapMetal = new ScrapMetalOutput();
    }

    @Override
    public IMachineRecipeList.RecipeEntry getRecipeInAndOutput(ItemStack input, boolean ignore) {
        if (input.func_190926_b()) {
            return null;
        }
        if (this.filter.isItemAllowed(input)) {
            IMachineRecipeList.RecipeEntry entry = super.getRecipeInAndOutput(input, true);
            if (entry == null) {
                entry = this.isMetal(input) ? new IMachineRecipeList.RecipeEntry(new RecipeInputItemStack(input, 1), this.scrapMetal, "ScrapMetal") : new IMachineRecipeList.RecipeEntry(new RecipeInputItemStack(input, 1), this.scrap, "Scrap");
            }
            if (!ignore && input.func_190916_E() < entry.getInput().getAmount()) {
                return null;
            }
            return entry;
        }
        return null;
    }

    public boolean isMetal(ItemStack stack) {
        for (int oreEntry : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (this.metalIDs.contains(oreEntry)) {
                return true;
            }
            String name = OreDictionary.getOreName((int)oreEntry);
            if (!name.startsWith("ingot") && !name.startsWith("metal")) continue;
            this.metalIDs.add(oreEntry);
            return true;
        }
        return false;
    }

    @Override
    public IMachineFilter getFilter() {
        return this.filter;
    }
}

