/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.tile;

import ic2.api.classic.network.ICustomNetworkClientTileEventListener;
import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.trading.providers.IEnergyTradeProvider;
import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.trading.trades.TradeType;
import ic2.api.item.ElectricItem;
import ic2.api.tile.IEnergyStorage;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.block.personal.base.TileEntityTradeOMatBase;
import ic2.core.block.personal.base.misc.IOwnerBlock;
import ic2.core.block.personal.base.misc.IPersonalEnergyStorage;
import ic2.core.block.personal.base.misc.IPersonalInventory;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.base.trades.builder.EnergyTradeFabricator;
import ic2.core.block.personal.base.trades.builder.ItemTradeFabricator;
import ic2.core.block.personal.base.trades.builder.TradeInventoryPlayer;
import ic2.core.block.personal.container.ContainerEnergyOMatClosed;
import ic2.core.block.personal.container.ContainerEnergyOMatOpen;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.math.IntCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;

public class TileEntityEnergyOMat
extends TileEntityTradeOMatBase
implements IOwnerBlock,
IEnergyTradeProvider,
INetworkClientTileEventListener,
ICustomNetworkClientTileEventListener,
IHasGui {
    @NetworkField(index=3)
    public UUID owner;
    @NetworkField(index=4)
    public int state = 0;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit8)
    public int currentSubTrade = 0;
    public PersonalInventory display = new PersonalInventory(8);
    public EnergyTradeFabricator fab = new EnergyTradeFabricator();
    @NetworkField(index=6)
    public IntCounter currentEnergy = new IntCounter();
    Map<UUID, IPersonalInventory> tradersMap = new HashMap<UUID, IPersonalInventory>();

    public TileEntityEnergyOMat() {
        this.addNetworkFields("owner");
    }

    public IPersonalInventory getInvForPlayer(EntityPlayer player) {
        return this.getInvForPlayer(player.func_110124_au());
    }

    public IPersonalInventory getInvForPlayer(UUID player) {
        IPersonalInventory inv = this.tradersMap.get(player);
        if (inv == null) {
            inv = new PersonalInventory(16);
            this.tradersMap.put(player, inv);
        }
        return inv;
    }

    @Override
    public TradeType getType() {
        return TradeType.Energy;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.energyOMat;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_186855_b("BlockOwner")) {
            this.owner = nbt.func_186857_a("BlockOwner");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.owner != null) {
            nbt.func_186854_a("BlockOwner", this.owner);
        }
        return nbt;
    }

    @Override
    public void setOwner(UUID user) {
        if (this.owner == null && user != null) {
            this.owner = user;
            this.getNetwork().updateTileEntityField(this, "owner");
        }
    }

    @Override
    public boolean canAccess(UUID user) {
        if (this.owner == null) {
            this.setOwner(user);
            return true;
        }
        return this.owner.equals(user);
    }

    @Override
    public int getNearbyEnergy(int requested, boolean simulate) {
        int used = 0;
        for (Direction dir : Direction.directions) {
            IEnergyStorage storage;
            TileEntity tile = dir.applyToTileEntity(this);
            if (tile == null || (storage = this.getStorage(tile)) == null) continue;
            int provided = storage.getStored();
            int needed = Math.min(requested - used, provided);
            if (!simulate) {
                storage.setStored(provided - needed);
            }
            if (requested - (used += needed) <= 0) break;
        }
        return used;
    }

    public IEnergyStorage getStorage(TileEntity tile) {
        IPersonalEnergyStorage personal;
        if (tile instanceof IPersonalEnergyStorage && (personal = (IPersonalEnergyStorage)tile).canAccess(this.getOwner())) {
            return personal.getStorage(this.getOwner());
        }
        return null;
    }

    @Override
    public void onClientNetworkEvent(EntityPlayer player, INetworkFieldData data) {
        if (player == null) {
            return;
        }
        if (data instanceof PayloadFieldPacket) {
            PayloadFieldPacket payload = (PayloadFieldPacket)data;
            if (this.isOwner(player) && payload.getSize(0) == 1) {
                this.addTrade(IC2.manager.getCustomTrades(this.getType()).get(payload.getString(0)));
            }
            if (payload.getSize(1) == 1) {
                if (player.field_71070_bA instanceof ContainerEnergyOMatClosed) {
                    ISubTrade sub;
                    ContainerEnergyOMatClosed cont = (ContainerEnergyOMatClosed)player.field_71070_bA;
                    UUID playerID = player.func_110124_au();
                    ITrade trade = this.getSyncer().getServerTrade(player);
                    cont.stockCount = trade != null && trade.canAccessTrade(playerID) ? ((sub = trade.getSubTradeFromSlot(payload.getNumber(0), playerID, true)) != null && sub.canPerformTrade(playerID) ? trade.getStockCount(sub, this, playerID) : 0) : 0;
                    cont.func_75142_b();
                }
            } else if (payload.getSize(1) == 2) {
                UUID playerID = player.func_110124_au();
                ITrade trade = this.getSyncer().getServerTrade(player);
                if (trade != null && trade.canAccessTrade(playerID)) {
                    ISubTrade sub = trade.getSubTradeFromSlot(payload.getNumber(0), playerID, true);
                    if (sub != null && sub.canPerformTrade(playerID)) {
                        List<Integer> energy = trade.getTradeResults(sub);
                        IPersonalInventory inv = this.getInvForPlayer(playerID);
                        PersonalInventory fake = new PersonalInventory(8);
                        fake.copy(inv, 8, 16);
                        if (this.canDoTrade(energy, fake)) {
                            ActionResult result = trade.trade(playerID, this, sub, new TradeInventoryPlayer(inv, player), payload.getNumber(1));
                            if (result == null || result.func_188397_a() == EnumActionResult.FAIL) {
                                IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                                return;
                            }
                            if (result.func_188397_a() == EnumActionResult.PASS) {
                                IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                                return;
                            }
                            fake.clear();
                            fake.copy(inv, 8, 16);
                            ArrayList tradeEnergy = new ArrayList((Collection)result.func_188398_b());
                            ArrayList<ItemStack> itemsToInject = new ArrayList<ItemStack>();
                            block0: for (Integer provided : tradeEnergy) {
                                int used = 0;
                                for (int i = 0; i < fake.getSlotCount(); ++i) {
                                    ItemStack stack = fake.getStackInSlot(i);
                                    if (stack.func_190926_b()) continue;
                                    if (stack.func_190916_E() > 1) {
                                        while (stack.func_190916_E() > 0) {
                                            ItemStack split = stack.func_77979_a(1);
                                            used = (int)((double)used + ElectricItem.manager.charge(split, provided - used, Integer.MAX_VALUE, true, false));
                                            itemsToInject.add(split);
                                            if (used < provided) continue;
                                            break;
                                        }
                                    } else {
                                        used = (int)((double)used + ElectricItem.manager.charge(stack, provided - used, Integer.MAX_VALUE, true, false));
                                    }
                                    if (used >= provided) continue block0;
                                }
                            }
                            IItemTransporter trans = TransporterManager.manager.getTransporter(fake, true);
                            for (int i = 0; i < itemsToInject.size(); ++i) {
                                ItemStack added;
                                ItemStack use = ((ItemStack)itemsToInject.get(i)).func_77946_l();
                                if (use.func_190926_b() || (added = trans.addItem(use, EnumFacing.DOWN, true)).func_190926_b()) continue;
                                use.func_190918_g(added.func_190916_E());
                                if (player.field_71071_by.func_70441_a(use)) continue;
                                player.func_71019_a(use, true);
                            }
                            fake.inject(inv, 8, 16);
                        } else {
                            IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNoRoom);
                        }
                    } else {
                        IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                    }
                } else {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                }
            }
        }
    }

    public boolean canDoTrade(List<Integer> energyList, IPersonalInventory inv) {
        int i;
        int totalEnergy = 0;
        for (i = 0; i < energyList.size(); ++i) {
            totalEnergy += energyList.get(i).intValue();
        }
        for (i = 0; i < inv.getSlotCount(); ++i) {
            ItemStack item = inv.getStackInSlot(i);
            if (item.func_190926_b()) continue;
            if (item.func_190916_E() > 1) {
                while (item.func_190916_E() > 0) {
                    if ((totalEnergy = (int)((double)totalEnergy - ElectricItem.manager.charge(item.func_77979_a(1), totalEnergy, Integer.MAX_VALUE, true, true))) > 0) continue;
                    return true;
                }
                continue;
            }
            if ((totalEnergy = (int)((double)totalEnergy - ElectricItem.manager.charge(item, totalEnergy, Integer.MAX_VALUE, true, true))) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0) {
            this.state = value;
            this.getNetwork().updateTileGuiField(this, "state");
            if (player.field_71070_bA instanceof ContainerEnergyOMatOpen) {
                ContainerEnergyOMatOpen mat = (ContainerEnergyOMatOpen)player.field_71070_bA;
                if (this.state == 0) {
                    mat.lock();
                    this.fab.clear();
                    this.currentEnergy.reset();
                    this.currentSubTrade = 0;
                    this.getNetwork().updateTileGuiField(this, "currentEnergy");
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                    this.display.clear();
                    this.getSyncer().markDirty(player);
                } else if (this.state == 1) {
                    mat.unlockAndUpdate();
                } else if (this.state == 2) {
                    mat.lock();
                    this.display.clear();
                    this.currentEnergy.reset();
                    this.getNetwork().updateTileGuiField(this, "currentEnergy");
                }
            }
        } else if (event == 2) {
            this.removeSubTrade(player, value);
        } else if (event == 4) {
            if (value > 0) {
                this.fab.setItems(this.display, this.currentEnergy, this.currentSubTrade);
                if (this.currentSubTrade < 3) {
                    ++this.currentSubTrade;
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                }
                if (!this.fab.hasKey(this.currentSubTrade)) {
                    this.fab.setItems(this.currentSubTrade, this.currentEnergy, this.display, value == 2 || value == 4, value == 3 || value == 4);
                }
                this.fab.pushToSlots(this.currentSubTrade, this.currentEnergy, this.display);
                this.getNetwork().updateTileGuiField(this, "currentEnergy");
            } else if (value < 0) {
                this.fab.setItems(this.display, this.currentEnergy, this.currentSubTrade);
                if (this.currentSubTrade > 0) {
                    --this.currentSubTrade;
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                }
                this.fab.pushToSlots(this.currentSubTrade, this.currentEnergy, this.display);
                this.getNetwork().updateTileGuiField(this, "currentEnergy");
            }
        } else if (event == 5) {
            ItemTradeFabricator.ItemTradeRules rules = this.fab.getRules(this.currentSubTrade);
            if (value == 0) {
                rules.creative = !rules.creative;
            } else if (value == 1) {
                boolean bl = rules.money = !rules.money;
                if (player.field_71070_bA instanceof ContainerEnergyOMatOpen) {
                    ContainerEnergyOMatOpen mat = (ContainerEnergyOMatOpen)player.field_71070_bA;
                    if (rules.money) {
                        mat.lockInput();
                        this.display.clear(0, 8);
                        this.fab.removeInput(this.currentSubTrade);
                        mat.func_75142_b();
                    } else {
                        mat.unlockInput();
                    }
                }
            } else if (value == 4) {
                rules.waitingAfterBuy = !rules.waitingAfterBuy;
            } else if (value == 5) {
                rules.tradeLimit = !rules.tradeLimit;
            } else if (value == 6) {
                rules.ignoreNBT = !rules.ignoreNBT;
            } else if (value == 7) {
                rules.useOreDictionary = !rules.useOreDictionary;
            }
        } else if (event == 6) {
            this.fab.getRules((int)this.currentSubTrade).moneyNeeded = value;
        } else if (event == 7) {
            this.fab.getRules((int)this.currentSubTrade).limitPerPlayer = value;
        } else if (event == 8) {
            this.fab.getRules((int)this.currentSubTrade).waitingTime = value;
        } else if (event == 10) {
            this.fab.setItems(this.display, this.currentEnergy, this.currentSubTrade);
            this.addTrade(this.fab.createTrade(this.getOwner()));
            this.fab.clear();
            this.currentEnergy.reset();
            this.display.clear();
            this.state = 0;
            this.currentSubTrade = 0;
            this.getNetwork().updateTileGuiField(this, "currentSubTrade");
            this.getNetwork().updateTileGuiField(this, "state");
            this.getNetwork().updateTileGuiField(this, "currentEnergy");
            if (player.field_71070_bA instanceof ContainerEnergyOMatOpen) {
                ((ContainerEnergyOMatOpen)player.field_71070_bA).lock();
            }
        } else if (event == 11) {
            this.currentEnergy.setValue(value);
            this.getNetwork().updateTileGuiField(this, "currentEnergy");
        }
    }

    public boolean isOwner(EntityPlayer player) {
        return this.owner.equals(player.func_110124_au());
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        if (this.isSimulating()) {
            this.getSyncer().createDataForPlayer(player);
        }
        if (this.canAccess(player.func_110124_au()) && !IC2.keyboard.isSideinventoryKeyDown(player)) {
            return new ContainerEnergyOMatOpen(player.field_71071_by, this);
        }
        return new ContainerEnergyOMatClosed(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
        this.getSyncer().clearDataForPlayer(player);
        this.tradersMap.remove(player.func_110124_au());
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }
}

