/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import ic2.core.IC2;
import ic2.core.item.block.ItemBlockRare;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemBlockCompactedGenerator
extends ItemBlockRare {
    public ItemBlockCompactedGenerator(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
        if (handler.hasEUReader() && stack.func_77960_j() < 6) {
            tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(this.getProduction(stack.func_77960_j())));
        }
    }

    private double getProduction(int meta) {
        switch (meta) {
            case 0: {
                return this.getPercentage("energyGeneratorSolarLV", 100) * 8.0;
            }
            case 1: {
                return this.getPercentage("energyGeneratorSolarMV", 100) * 64.0;
            }
            case 2: {
                return this.getPercentage("energyGeneratorSolarHV", 100) * 512.0;
            }
            case 3: {
                return this.getPercentage("energyGeneratorWaterLV", 100) * 4.0;
            }
            case 4: {
                return this.getPercentage("energyGeneratorWaterMV", 100) * 32.0;
            }
            case 5: {
                return this.getPercentage("energyGeneratorWaterHV", 100) * 128.0;
            }
        }
        return 0.0;
    }

    private double getPercentage(String id, int max) {
        return (double)IC2.config.getFloat(id) / (double)max;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2BlockLang.solarLV;
            }
            case 1: {
                return Ic2BlockLang.solarMV;
            }
            case 2: {
                return Ic2BlockLang.solarHV;
            }
            case 3: {
                return Ic2BlockLang.waterLV;
            }
            case 4: {
                return Ic2BlockLang.waterMV;
            }
            case 5: {
                return Ic2BlockLang.waterHV;
            }
            case 6: {
                return Ic2BlockLang.LVRFProducer;
            }
            case 7: {
                return Ic2BlockLang.MVRFProducer;
            }
            case 8: {
                return Ic2BlockLang.HVRFProducer;
            }
        }
        return super.getLangComponent(stack);
    }
}

