/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.core.item.render.model.FluidModel;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledItem;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDisplayIcon
extends Item
implements IStaticTexturedItem,
ICustomModeledItem,
IBootable {
    public ItemDisplayIcon() {
        this.func_77655_b("itemDisplayIcons");
        this.func_77627_a(true);
    }

    @Override
    public void onLoad() {
        ItemStack[] array = new ItemStack[25];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new ItemStack((Item)this, 1, i);
        }
        Ic2Items.displayIcons = array;
        Ic2Items.fluidDisplay = new ItemStack((Item)this, 1, 25);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Integer> getValidVariants() {
        ArrayList<Integer> list = new ArrayList<Integer>(25);
        TextureAtlasSprite[] array = Ic2Icons.getTextures("Gui");
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            list.add(i);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("Gui")[meta];
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public String func_77667_c(ItemStack stack) {
        return "item.itemDisplayIcon" + stack.func_77960_j();
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid;
        if (stack.func_77960_j() == 25 && (fluid = ItemDisplayIcon.getFluidStack(stack)) != null) {
            return fluid.getLocalizedName();
        }
        return "";
    }

    public String func_77657_g(ItemStack stack) {
        FluidStack fluid;
        if (stack.func_77960_j() == 25 && (fluid = ItemDisplayIcon.getFluidStack(stack)) != null) {
            return fluid.getLocalizedName();
        }
        return "";
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        FluidStack fluid;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77960_j() == 25 && (fluid = ItemDisplayIcon.getFluidStack(stack)) != null) {
            tooltip.add(Ic2GuiLang.fluidAmountSingle.getLocalizedFormatted(fluid.amount));
        }
    }

    @Override
    public List<ItemStack> getValidItemTypes() {
        return Arrays.asList(new ItemStack((Item)this, 1, 25));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromItem(ItemStack item) {
        return new FluidModel();
    }

    public static void setFluidStack(ItemStack item, FluidStack fluid) {
        item.func_77983_a("FluidData", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
    }

    public static FluidStack getFluidStack(ItemStack item) {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)item.func_190925_c("FluidData"));
    }

    public static ItemStack createWithFluidStack(FluidStack fluid) {
        if (fluid == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = Ic2Items.fluidDisplay.func_77946_l();
        ItemDisplayIcon.setFluidStack(result, fluid);
        return result;
    }
}

