/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.uranTypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class EnderUranium
extends UranBaseType {
    public EnderUranium() {
        this.addArray(-1, -1);
        this.addArray(0, -1);
        this.addArray(1, -1);
        this.addArray(-1, 0);
        this.addArray(1, 0);
        this.addArray(-1, 1);
        this.addArray(0, 1);
        this.addArray(1, 1);
    }

    @Override
    public int getMaxDurability() {
        return 5000;
    }

    @Override
    public float getEUPerPulse() {
        return 1.0f;
    }

    @Override
    public int getPulsesPerTick() {
        return 1;
    }

    @Override
    public int getPulsesForConnection() {
        return 1;
    }

    @Override
    public float getHeatModifier() {
        return 1.0f;
    }

    @Override
    public float getExplosionEffectModifier() {
        return 2.0f;
    }

    @Override
    public ItemStack getUraniumIngot() {
        return Ic2Items.enderPearlUraniumIngot.func_77946_l();
    }

    @Override
    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2Items.reactorEnderPearlUraniumRodSingle.func_77946_l();
            }
            case DualRod: {
                return Ic2Items.reactorEnderPearlUraniumRodDual.func_77946_l();
            }
            case QuadRod: {
                return Ic2Items.reactorEnderPearlUraniumRodQuad.func_77946_l();
            }
            case NearDepletedRod: {
                return Ic2Items.reactorNearDepletedEnderPearlUraniumRod.func_77946_l();
            }
            case IsotopicRod: {
                return Ic2Items.reactorEnderPearlUraniumIsotopicRod.func_77946_l();
            }
            case ReEnrichedRod: {
                return Ic2Items.reactorReEnrichedEnderPearlUraniumRod.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage(this.getRodType(IUranium.RodType.IsotopicRod), this.getMaxDurability() - 1);
    }

    @Override
    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 9;
            }
            case DualRod: {
                return 10;
            }
            case QuadRod: {
                return 11;
            }
            case IsotopicRod: {
                return 45;
            }
        }
        return 0;
    }

    @Override
    public LocaleComp getName(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2ItemLang.uranRodEnderSingle;
            }
            case DualRod: {
                return Ic2ItemLang.uranRodEnderDouble;
            }
            case QuadRod: {
                return Ic2ItemLang.uranRodEnderQuad;
            }
            case NearDepletedRod: {
                return Ic2ItemLang.uranRodEnderNearDeplete;
            }
            case IsotopicRod: {
                return Ic2ItemLang.uranRodEnderIsotopic;
            }
            case ReEnrichedRod: {
                return Ic2ItemLang.uranRodEnderReEnriched;
            }
        }
        return Ic2Lang.nullKey;
    }

    @Override
    public boolean isReEnrichedUran() {
        return true;
    }

    @Override
    public Color getReEnrichedColor() {
        return new Color(2338417);
    }

    @Override
    public ItemStack getIngridient() {
        return new ItemStack(Items.field_151079_bi);
    }

    @Override
    public int getIngrientPoints() {
        return 100;
    }

    @Override
    public int getRow() {
        return 3;
    }

    @Override
    public int getIngridientCost() {
        return 75;
    }
}

