/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.recipe.entry;

import ic2.api.recipe.IRecipeInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeInputCombined
implements IRecipeInput {
    int items;
    public List<IRecipeInput> inputs = new ArrayList<IRecipeInput>();

    public RecipeInputCombined(int stackSize, IRecipeInput ... in) {
        this.items = stackSize;
        this.inputs.addAll(Arrays.asList(in));
    }

    public RecipeInputCombined(List<IRecipeInput> in) {
        this.inputs.addAll(in);
        for (IRecipeInput input : in) {
            this.items = Math.max(this.items, input.getAmount());
        }
    }

    @Override
    public boolean matches(ItemStack subject) {
        for (IRecipeInput in : this.inputs) {
            if (!in.matches(subject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getAmount() {
        return this.items;
    }

    @Override
    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (IRecipeInput in : this.inputs) {
            list.addAll(in.getInputs());
        }
        return list;
    }
}

