/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IMiningDrill;
import ic2.api.event.LaserEvent;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkItemEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.entity.misc.EntityMiningLaser;
import ic2.core.entity.misc.EntityTrackingMiningLaser;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricMiningLaser
extends ItemIC2
implements INetworkItemEventListener,
IDamagelessElectricItem,
IMiningDrill,
ICustomItemCameraTransform,
IBootable {
    public static final int[] modeCost = new int[]{1250, 100, 5000, 0, 2500, 10000, 5000, 10000};

    public ItemElectricMiningLaser() {
        this.setUnlocalizedName(Ic2ItemLang.miningLaser);
        this.func_77625_d(1);
    }

    @Override
    public void onLoad() {
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new TurretDispenserHandler());
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public int getTextureEntry(int meta) {
        return 38;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        tooltip.add(Ic2InfoLang.laserMode.getLocalizedFormatted(this.getLaserMode(StackUtil.getNbtData(stack).func_74762_e("Mode"))));
        List<String> ctrlList = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlList.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlList.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.miningLaserModes));
    }

    public LocaleComp getLaserMode(int mode) {
        switch (mode) {
            case 0: {
                return Ic2InfoLang.laserModeMining;
            }
            case 1: {
                return Ic2InfoLang.laserModeLowFocus;
            }
            case 2: {
                return Ic2InfoLang.laserModeLongRange;
            }
            case 3: {
                return Ic2InfoLang.laserModeHorizontal;
            }
            case 4: {
                return Ic2InfoLang.laserModeSuperHeat;
            }
            case 5: {
                return Ic2InfoLang.laserModeScatter;
            }
            case 6: {
                return Ic2InfoLang.laserModeExplosive;
            }
            case 7: {
                return Ic2InfoLang.laserModeTracking;
            }
        }
        return Ic2Lang.nullKey;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isRendering()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("Mode");
        if (IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
            mode = (mode + 1) % 8;
            nbt.func_74768_a("Mode", mode);
            IC2.platform.messagePlayer(playerIn, Ic2InfoLang.laserMode, this.getLaserMode(mode));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (mode != 3 && mode != 7) {
            if (!ElectricItem.manager.use(stack, modeCost[mode], (EntityLivingBase)playerIn)) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            if (mode == 5) {
                boolean didShoot = false;
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -2; y <= 2; ++y) {
                        EntityMiningLaser laser = this.getMiningLaser(mode, worldIn, playerIn, playerIn.field_70177_z + (float)(20 * x), playerIn.field_70125_A + (float)(20 * y));
                        LaserEvent.LaserShootEvent event = new LaserEvent.LaserShootEvent(worldIn, laser, (EntityLivingBase)playerIn, laser.range, laser.power, laser.blockBreaks, laser.explosive, laser.smelt, stack);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (event.isCanceled()) continue;
                        worldIn.func_72838_d((Entity)laser);
                        didShoot = true;
                    }
                }
                IC2.network.get().initiateItemEvent(playerIn, stack, mode, true);
                return new ActionResult(didShoot ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, (Object)stack);
            }
            EntityMiningLaser laser = this.getMiningLaser(mode, worldIn, playerIn, 0.0, 0.0);
            if (laser != null) {
                LaserEvent.LaserShootEvent event = new LaserEvent.LaserShootEvent(worldIn, laser, (EntityLivingBase)playerIn, laser.range, laser.power, laser.blockBreaks, laser.explosive, laser.smelt, stack);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                worldIn.func_72838_d((Entity)laser);
                IC2.network.get().initiateItemEvent(playerIn, stack, mode, true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        } else if (mode == 7) {
            RayTraceResult result = ItemElectricMiningLaser.rayTraceEntities(worldIn, (EntityLivingBase)playerIn, false, 60.0);
            if (result != null && result.field_72313_a == RayTraceResult.Type.ENTITY) {
                if ((result.field_72308_g instanceof EntityLivingBase || result.field_72308_g instanceof MultiPartEntityPart || result.field_72308_g instanceof EntityEnderCrystal) && ElectricItem.manager.use(stack, modeCost[mode], (EntityLivingBase)playerIn)) {
                    EntityTrackingMiningLaser laser = new EntityTrackingMiningLaser(worldIn, (EntityLivingBase)playerIn, 4.0f, 64.0f, 5, result.field_72308_g);
                    LaserEvent.LaserShootEvent event = new LaserEvent.LaserShootEvent(worldIn, laser, (EntityLivingBase)playerIn, laser.range, laser.power, laser.blockBreaks, laser.explosive, laser.smelt, stack);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled() || !laser.canHitPlayer(result)) {
                        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                    }
                    worldIn.func_72838_d((Entity)laser);
                    IC2.network.get().initiateItemEvent(playerIn, stack, mode, true);
                }
            } else {
                IC2.platform.messagePlayer(playerIn, Ic2InfoLang.laserNeedsTarget);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        int mode = StackUtil.getNbtData(stack).func_74762_e("Mode");
        if (!IC2.keyboard.isModeSwitchKeyDown(player) && mode == 3) {
            if (Math.abs(player.field_70163_u + (double)player.func_70047_e() - 0.1 - ((double)pos.func_177956_o() + 0.5)) < 1.5) {
                EntityMiningLaser laser;
                if (!ElectricItem.manager.canUse(stack, 3000.0)) {
                    return EnumActionResult.PASS;
                }
                if (IC2.platform.isRendering()) {
                    return EnumActionResult.PASS;
                }
                if (ElectricItem.manager.use(stack, 3000.0, (EntityLivingBase)player) && (laser = new EntityMiningLaser(worldIn, (EntityLivingBase)player, 1.5f, 5.0f, Integer.MAX_VALUE, false, player.field_70177_z, 0.0, (float)pos.func_177956_o() + 0.5f)) != null) {
                    LaserEvent.LaserShootEvent event = new LaserEvent.LaserShootEvent(worldIn, laser, (EntityLivingBase)player, laser.range, laser.power, laser.blockBreaks, laser.explosive, laser.smelt, stack);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) {
                        return EnumActionResult.FAIL;
                    }
                    worldIn.func_72838_d((Entity)laser);
                    IC2.network.get().initiateItemEvent(player, stack, 3, true);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            IC2.platform.messagePlayer(player, Ic2InfoLang.laserWrongAim);
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public EntityMiningLaser getMiningLaser(int mode, World world, EntityPlayer player, double yaw, double pitch) {
        switch (mode) {
            case 0: {
                return new EntityMiningLaser(world, (EntityLivingBase)player, 2.0f, 5.0f, Integer.MAX_VALUE, false);
            }
            case 1: {
                return new EntityMiningLaser(world, (EntityLivingBase)player, 1.1f, 5.0f, 1, false);
            }
            case 2: {
                return new EntityMiningLaser(world, (EntityLivingBase)player, 2.0f, 32.0f, Integer.MAX_VALUE, false);
            }
            case 4: {
                return new EntityMiningLaser(world, (EntityLivingBase)player, 2.0f, 8.0f, Integer.MAX_VALUE, false, true);
            }
            case 5: {
                return new EntityMiningLaser(world, (EntityLivingBase)player, 2.0f, 12.0f, Integer.MAX_VALUE, false, yaw, pitch);
            }
            case 6: {
                return new EntityMiningLaser(world, (EntityLivingBase)player, 2.0f, 12.0f, Integer.MAX_VALUE, true);
            }
        }
        return null;
    }

    @Override
    public void onNetworkEvent(ItemStack stack, EntityPlayer player, int event) {
        if (event >= 0 && event < 8) {
            IC2.audioManager.playOnce(player, PositionSpec.Hand, this.getMiningLaserSound(event), true, IC2.audioManager.getDefaultVolume());
        }
    }

    public ResourceLocation getMiningLaserSound(int sound) {
        switch (sound) {
            case 1: {
                return Ic2Sounds.miningLaserLowFocus;
            }
            case 2: {
                return Ic2Sounds.miningLaserLongRange;
            }
            case 3: {
                return Ic2Sounds.miningLaser;
            }
            case 4: {
                return Ic2Sounds.miningLaser;
            }
            case 5: {
                return Ic2Sounds.miningLaserScatter;
            }
            case 6: {
                return Ic2Sounds.miningLaserExplosive;
            }
            case 7: {
                return Ic2Sounds.miningLaserLongRange;
            }
        }
        return Ic2Sounds.miningLaser;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 200000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 120.0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)empty);
        items.add((Object)full);
    }

    @Override
    public boolean isBasicDrill(ItemStack drill) {
        return false;
    }

    @Override
    public int getExtraSpeed(ItemStack drill) {
        return 100;
    }

    @Override
    public int getExtraEnergyCost(ItemStack drill) {
        return 80;
    }

    @Override
    public void useDrill(ItemStack drill) {
        ElectricItem.manager.discharge(drill, 250.0, 2, true, false, false);
    }

    @Override
    public boolean canMine(ItemStack drill) {
        return ElectricItem.manager.canUse(drill, 250.0);
    }

    @Override
    public boolean canMineBlock(ItemStack drill, IBlockState state, IBlockAccess access, BlockPos pos) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !StackUtil.getNbtData(stack).func_74767_n("HideDurability");
    }

    public static class TurretDispenserHandler
    extends BehaviorDefaultDispenseItem {
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            int mode = StackUtil.getNbtData(stack).func_74762_e("Mode");
            if (mode == 3 || mode == 5) {
                return stack;
            }
            if (!ElectricItem.manager.canUse(stack, modeCost[mode])) {
                return stack;
            }
            BlockPos basePos = source.func_180699_d().func_177977_b();
            EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos offset = basePos.func_177972_a(facing);
            FakePlayer fake = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)source.func_82618_k()));
            this.applyToPlayer((EntityPlayer)fake, offset);
            fake.field_70177_z = facing.func_185119_l();
            fake.field_70125_A = facing.func_176740_k().func_176722_c() ? 0.0f : (float)(facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? -90 : 90);
            boolean didShoot = false;
            if (mode == 7) {
                List mobs = source.func_82618_k().func_72872_a(EntityMob.class, new AxisAlignedBB(basePos.func_177967_a(facing, 21)).func_186662_g(21.0));
                if (mobs.size() > 0) {
                    EntityTrackingMiningLaser laser = new EntityTrackingMiningLaser(source.func_82618_k(), (EntityLivingBase)fake, 4.0f, 64.0f, 5, (Entity)mobs.get(source.func_82618_k().field_73012_v.nextInt(mobs.size())));
                    laser.clearThrower();
                    source.func_82618_k().func_72838_d((Entity)laser);
                    didShoot = true;
                }
            } else {
                EntityMiningLaser laser = ((ItemElectricMiningLaser)stack.func_77973_b()).getMiningLaser(mode, source.func_82618_k(), (EntityPlayer)fake, 0.0, 0.0);
                if (laser != null) {
                    laser.clearThrower();
                    source.func_82618_k().func_72838_d((Entity)laser);
                    didShoot = true;
                }
            }
            this.applyToPlayer((EntityPlayer)fake, BlockPos.field_177992_a);
            if (didShoot) {
                ElectricItem.manager.use(stack, modeCost[mode], null);
                this.tryRecharge(source.func_82618_k(), source.func_180699_d().func_177972_a(facing.func_176734_d()), stack);
            }
            return stack;
        }

        public void applyToPlayer(EntityPlayer player, BlockPos pos) {
            player.field_70165_t = pos.func_177958_n();
            player.field_70163_u = pos.func_177956_o();
            player.field_70161_v = pos.func_177952_p();
            player.field_70177_z = 0.0f;
            player.field_70125_A = 0.0f;
        }

        public void tryRecharge(World world, BlockPos target, ItemStack stack) {
            IEnergyStorage storage;
            int provided;
            TileEntity tile;
            if (world.func_175667_e(target) && (tile = world.func_175625_s(target)) instanceof IEnergyStorage && (provided = (storage = (IEnergyStorage)tile).getStored()) > 0) {
                provided = (int)((double)provided - ElectricItem.manager.charge(stack, provided, Integer.MAX_VALUE, true, false));
                storage.setStored(provided);
            }
        }

        protected void func_82485_a(IBlockSource source) {
        }
    }
}

