/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricToolChainsaw
extends ItemElectricTool
implements IStaticTexturedItem {
    public static ItemStack ironAxe = new ItemStack(Items.field_151036_c);
    AudioSource lastSource;

    public ItemElectricToolChainsaw() {
        super(0.0f, 0.0f, Item.ToolMaterial.IRON);
        this.field_77865_bY = 1.0f;
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.operationEnergyCost = 50;
        this.tier = 1;
        this.field_77864_a = 12.0f;
        this.setHarvestLevel("axe", 2);
        this.setUnlocalizedName(Ic2ItemLang.chainsaw);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return ironAxe.func_150998_b(state) || state.func_177230_c() == Blocks.field_150321_G;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        if (!ElectricItem.manager.canUse(stack, this.getEnergyCost(stack))) {
            return 1.0f;
        }
        if (material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151584_j) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase entity, EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(stack, (IBlockAccess)entity.field_70170_p, pos) && ElectricItem.manager.canUse(stack, this.getEnergyCost(stack) * 2)) {
                List drops = target.onSheared(stack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                for (ItemStack item : drops) {
                    EntityItem ent = entity.func_70099_a(item, 1.0f);
                    ent.field_70181_x += (double)(entity.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
                }
                ElectricItem.manager.use(stack, this.getEnergyCost(stack) * 2, (EntityLivingBase)playerIn);
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, pos) && ElectricItem.manager.canUse(itemstack, this.getEnergyCost(itemstack))) {
            List drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack));
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            ElectricItem.manager.use(itemstack, this.getEnergyCost(itemstack), (EntityLivingBase)player);
            player.func_71029_a(StatList.func_188055_a((Block)block));
            if (block == Blocks.field_150321_G) {
                player.field_70170_p.func_175698_g(pos);
                IC2.achievements.issueStat(player, "blocksSawed");
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksSawed");
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i1")[34];
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.DIGGER;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return ench instanceof EnchantmentDamage;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!(attacker instanceof EntityPlayer)) {
            return true;
        }
        if (ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)((EntityPlayer)attacker))) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 10.0f);
        } else {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 1.0f);
        }
        if (target.func_110143_aJ() <= 0.0f) {
            if (target instanceof EntityCreeper) {
                IC2.achievements.issueStat((EntityPlayer)attacker, "killCreeperChainsaw");
            }
            if (attacker instanceof EntityPlayer) {
                IC2.achievements.issueStat((EntityPlayer)attacker, "chainsawKills");
            }
        }
        return false;
    }
}

