/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.classic.energy.render.IRenderValidator;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.energy.render.EnergyNetRenderer;
import ic2.core.energy.render.RenderPath;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyNetRendererPacket
extends IC2Packet {
    IRenderValidator validator;
    List<Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>>> list = new ArrayList<Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>>>();

    public EnergyNetRendererPacket() {
    }

    public EnergyNetRendererPacket(IRenderValidator valid, List<Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>>> data) {
        this.validator = valid;
        this.list.addAll(data);
    }

    @Override
    public void read(ByteBuf par1) {
        InputBuffer buffer = new InputBuffer(par1);
        try {
            Class<?> clz = Class.forName(buffer.readString(NetworkField.BitLevel.Bit16));
            if (clz == null) {
                return;
            }
            this.validator = (IRenderValidator)clz.newInstance();
            this.validator.readClientData(buffer.readNBTData());
        }
        catch (Exception e) {
            return;
        }
        if (this.validator == null) {
            return;
        }
        int size = buffer.readByte();
        for (int x = 0; x < size; ++x) {
            BlockPos pos = BlockPos.func_177969_a((long)buffer.readLong());
            HashMap key = new HashMap();
            HashMap<BlockPos, Double> value = new HashMap<BlockPos, Double>();
            int keySize = buffer.readShort();
            for (int y = 0; y < keySize; ++y) {
                BlockPos keyPos = BlockPos.func_177969_a((long)buffer.readLong());
                ArrayList<BlockPos> valueList = new ArrayList<BlockPos>();
                int valueSize = buffer.readByte();
                for (int z = 0; z < valueSize; ++z) {
                    valueList.add(BlockPos.func_177969_a((long)buffer.readLong()));
                }
                key.put(keyPos, valueList);
            }
            int valueSize = buffer.readShort();
            for (int y = 0; y < valueSize; ++y) {
                BlockPos keyPosition = BlockPos.func_177969_a((long)buffer.readLong());
                double loss = buffer.readDouble();
                value.put(keyPosition, loss);
            }
            this.list.add((Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>>)new Tuple((Object)pos, (Object)new Tuple(key, value)));
        }
    }

    @Override
    public void write(ByteBuf par1) {
        OutputBuffer buffer = new OutputBuffer(par1);
        try {
            buffer.writeString(this.validator.getClass().getName(), NetworkField.BitLevel.Bit16);
            NBTTagCompound nbt = new NBTTagCompound();
            this.validator.writeServerData(nbt);
            buffer.writeNBTData(nbt);
            buffer.writeByte((byte)this.list.size());
            for (Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>> entry : this.list) {
                BlockPos pos = (BlockPos)entry.func_76341_a();
                buffer.writeLong(pos.func_177986_g());
                Tuple list = (Tuple)entry.func_76340_b();
                Map key = (Map)list.func_76341_a();
                buffer.writeShort((short)key.size());
                for (Map.Entry pathEntry : key.entrySet()) {
                    buffer.writeLong(((BlockPos)pathEntry.getKey()).func_177986_g());
                    List data = (List)pathEntry.getValue();
                    buffer.writeByte((byte)data.size());
                    for (BlockPos position : data) {
                        buffer.writeLong(position.func_177986_g());
                    }
                }
                Map map = (Map)list.func_76340_b();
                buffer.writeShort((short)map.size());
                for (Map.Entry pathEntry : ((Map)list.func_76340_b()).entrySet()) {
                    buffer.writeLong(((BlockPos)pathEntry.getKey()).func_177986_g());
                    buffer.writeDouble((Double)pathEntry.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        if (this.validator == null) {
            return;
        }
        this.handleStuff(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStuff(EntityPlayer player) {
        ArrayList<RenderPath> paths = new ArrayList<RenderPath>();
        for (int i = 0; i < this.list.size(); ++i) {
            paths.add(new RenderPath(player, this.validator, this.list.get(i)));
        }
        EnergyNetRenderer.instance.addRenderer((Tuple<IRenderValidator, List<RenderPath>>)new Tuple((Object)this.validator, paths));
    }
}

