/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.render.constants.ConstantsDisk;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageDiskItemDriveWrapper
implements IStorageDisk<ItemStack> {
    private NetworkNodeDiskDrive diskDrive;
    private IStorageDisk<ItemStack> parent;
    private int lastState;

    public StorageDiskItemDriveWrapper(NetworkNodeDiskDrive diskDrive, IStorageDisk<ItemStack> parent) {
        this.diskDrive = diskDrive;
        this.parent = parent;
        this.setSettings(() -> {
            int currentState = ConstantsDisk.getDiskState(this.getStored(), this.getCapacity());
            if (this.lastState != currentState) {
                this.lastState = currentState;
                diskDrive.requestBlockUpdate();
            }
        }, diskDrive);
        this.lastState = ConstantsDisk.getDiskState(this.getStored(), this.getCapacity());
    }

    @Override
    public int getPriority() {
        return this.diskDrive.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    @Nullable
    public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
        if (!IFilterable.acceptsItem((IItemHandler)this.diskDrive.getItemFilters(), this.diskDrive.getMode(), this.diskDrive.getCompare(), stack)) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        }
        return this.parent.insert(stack, size, action);
    }

    @Override
    @Nullable
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
        return this.parent.extract(stack, size, flags, action);
    }

    @Override
    public int getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }

    @Override
    public int getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.parent.setSettings(listener, context);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        return this.parent.writeToNbt();
    }

    @Override
    public String getId() {
        return this.parent.getId();
    }
}

