/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render.model;

import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelDiskManipulator;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelFullbright;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class ModelDiskManipulator
implements IModel {
    private static final ResourceLocation MODEL_BASE_CUTOUT = new ResourceLocation("refinedstorage:block/cube_north_cutout");
    private static final ResourceLocation MODEL_BASE_CONNECTED = new ResourceLocation("refinedstorage:block/disk_manipulator_connected");
    private static final ResourceLocation MODEL_BASE_DISCONNECTED = new ResourceLocation("refinedstorage:block/disk_manipulator_disconnected");
    private static final ResourceLocation MODEL_DISK = new ResourceLocation("refinedstorage:block/disks/disk");
    private static final ResourceLocation MODEL_DISK_NEAR_CAPACITY = new ResourceLocation("refinedstorage:block/disks/disk_near_capacity");
    private static final ResourceLocation MODEL_DISK_FULL = new ResourceLocation("refinedstorage:block/disks/disk_full");
    private static final ResourceLocation MODEL_DISK_DISCONNECTED = new ResourceLocation("refinedstorage:block/disks/disk_disconnected");

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> dependencies = new ArrayList<ResourceLocation>();
        dependencies.add(MODEL_BASE_CUTOUT);
        dependencies.add(MODEL_BASE_CONNECTED);
        dependencies.add(MODEL_BASE_DISCONNECTED);
        dependencies.add(MODEL_DISK);
        dependencies.add(MODEL_DISK_NEAR_CAPACITY);
        dependencies.add(MODEL_DISK_FULL);
        dependencies.add(MODEL_DISK_DISCONNECTED);
        return dependencies;
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel diskModelDisconnected;
        IModel diskModelFull;
        IModel diskModelNearCapacity;
        IModel diskModel;
        IModel baseModelDisconnected;
        IModel baseModelConnected;
        try {
            baseModelConnected = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_BASE_CONNECTED);
            baseModelDisconnected = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_BASE_DISCONNECTED);
            diskModel = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_DISK);
            diskModelNearCapacity = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_DISK_NEAR_CAPACITY);
            diskModelFull = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_DISK_FULL);
            diskModelDisconnected = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_DISK_DISCONNECTED);
        }
        catch (Exception e) {
            throw new Error("Unable to load disk manipulator models", e);
        }
        return new BakedModelDiskManipulator(new BakedModelFullbright(baseModelConnected.bake(state, format, bakedTextureGetter), "refinedstorage:blocks/disk_manipulator/cutouts/connected"), baseModelDisconnected.bake(state, format, bakedTextureGetter), new BakedModelFullbright(diskModel.bake(state, format, bakedTextureGetter), "refinedstorage:blocks/disks/leds").setCacheDisabled(), new BakedModelFullbright(diskModelNearCapacity.bake(state, format, bakedTextureGetter), "refinedstorage:blocks/disks/leds").setCacheDisabled(), new BakedModelFullbright(diskModelFull.bake(state, format, bakedTextureGetter), "refinedstorage:blocks/disks/leds").setCacheDisabled(), diskModelDisconnected.bake(state, format, bakedTextureGetter));
    }
}

