/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks;

import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.ItemModelList;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ItemModels {
    private static final HashMap<Item, ItemModelList> models = new HashMap();

    public static void preInit() {
        ItemModels.defineItemModels();
        ItemModels.prepareModels();
    }

    public static void init() {
        ItemModels.registerModels();
    }

    private static void defineItemModels() {
        for (BlockBaseGarden blockBaseGarden : BlockRegistry.gardens.values()) {
            ItemModels.registerItemModels(ItemModels.getItem((Block)blockBaseGarden), new ItemModelList("gardens/").add(0, blockBaseGarden.getName()));
        }
        for (BlockPamCrop blockPamCrop : CropRegistry.getCrops().values()) {
            ItemModels.registerItemModels(ItemModels.getItem((Block)blockPamCrop), new ItemModelList("crops/").add(0, blockPamCrop.getStageId(0)).add(1, blockPamCrop.getStageId(1)).add(2, blockPamCrop.getStageId(2)).add(3, blockPamCrop.getStageId(3)));
        }
        for (BlockPamSapling blockPamSapling : FruitRegistry.getSaplings()) {
            ItemModels.registerItemModels(ItemModels.getItem((Block)blockPamSapling), new ItemModelList("saplings/").add(0, blockPamSapling.getName()));
        }
        for (BlockPamFruit blockPamFruit : FruitRegistry.fruits) {
            ItemModels.registerItemModels(ItemModels.getItem(blockPamFruit), new ItemModelList("fruits/").add(0, blockPamFruit.getStageId(0)).add(1, blockPamFruit.getStageId(1)).add(2, blockPamFruit.getStageId(2)));
        }
        for (BlockPamFruitLog blockPamFruitLog : FruitRegistry.logs.values()) {
            ItemModels.registerItemModels(ItemModels.getItem(blockPamFruitLog), new ItemModelList("fruits/").add(0, blockPamFruitLog.getStageId(0)).add(1, blockPamFruitLog.getStageId(1)).add(2, blockPamFruitLog.getStageId(2)));
        }
    }

    private static void registerItemModels(Item item, ItemModelList list) {
        models.put(item, list);
    }

    private static void prepareModels() {
        for (Map.Entry<Item, ItemModelList> entry : models.entrySet()) {
            Item item = entry.getKey();
            Collection<String> registrations = entry.getValue().getRegistrations().values();
            for (String registration : registrations) {
                if (item == null || registration == null) continue;
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(registration)});
            }
        }
    }

    private static void registerModels() {
        for (Map.Entry<Item, ItemModelList> entry : models.entrySet()) {
            Item item = entry.getKey();
            HashMap<Integer, String> registrations = entry.getValue().getRegistrations();
            for (Map.Entry<Integer, String> registration : registrations.entrySet()) {
                int meta = registration.getKey();
                String path = registration.getValue();
                ModelResourceLocation resource = new ModelResourceLocation(path, "inventory");
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, resource);
            }
        }
    }

    private static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }
}

