/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import forestry.api.modules.ForestryModule;
import forestry.core.ModuleCore;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.recipes.RecipeUtil;
import forestry.cultivation.blocks.BlockPlanter;
import forestry.cultivation.blocks.BlockRegistryCultivation;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.modules.BlankForestryModule;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

@ForestryModule(containerID="forestry", moduleID="cultivation", name="Cultivation", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.cultivation.description")
public class ModuleCultivation
extends BlankForestryModule {
    @Nullable
    private static BlockRegistryCultivation blocks;

    public static BlockRegistryCultivation getBlocks() {
        Preconditions.checkNotNull((Object)blocks);
        return blocks;
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryCultivation();
    }

    @Override
    public Set<ResourceLocation> getDependencyUids() {
        return ImmutableSet.of((Object)new ResourceLocation("forestry", "core"), (Object)new ResourceLocation("forestry", "farming"));
    }

    @Override
    public void doInit() {
        BlockRegistryCultivation blocks = ModuleCultivation.getBlocks();
        blocks.arboretum.init();
        blocks.farmCrops.init();
        blocks.farmMushroom.init();
        blocks.farmNether.init();
        blocks.farmGourd.init();
        blocks.farmEnder.init();
        blocks.peatBog.init();
    }

    @Override
    public void registerRecipes() {
        BlockRegistryCultivation blocks = ModuleCultivation.getBlocks();
        ItemRegistryCore coreItems = ModuleCore.getItems();
        RecipeUtil.addRecipe("arboretum", blocks.arboretum, "GTG", "TCT", "GBG", Character.valueOf('G'), "blockGlass", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.GOLD, 1), Character.valueOf('C'), coreItems.flexibleCasing, Character.valueOf('B'), coreItems.circuitboards.get(EnumCircuitBoardType.BASIC));
        RecipeUtil.addRecipe("farm_crops", blocks.farmCrops, "GTG", "TCT", "GBG", Character.valueOf('G'), "blockGlass", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.BRONZE, 1), Character.valueOf('C'), coreItems.flexibleCasing, Character.valueOf('B'), coreItems.circuitboards.get(EnumCircuitBoardType.BASIC));
        RecipeUtil.addRecipe("peat_bog", blocks.peatBog, "GTG", "TCT", "GBG", Character.valueOf('G'), "blockGlass", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.OBSIDIAN, 1), Character.valueOf('C'), coreItems.flexibleCasing, Character.valueOf('B'), coreItems.circuitboards.get(EnumCircuitBoardType.BASIC));
        RecipeUtil.addRecipe("farm_mushroom", blocks.farmMushroom, "GTG", "TCT", "GBG", Character.valueOf('G'), "blockGlass", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.APATITE, 1), Character.valueOf('C'), coreItems.flexibleCasing, Character.valueOf('B'), coreItems.circuitboards.get(EnumCircuitBoardType.BASIC));
        RecipeUtil.addRecipe("farm_gourd", blocks.farmGourd, "GTG", "TCT", "GBG", Character.valueOf('G'), "blockGlass", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.LAPIS, 1), Character.valueOf('C'), coreItems.flexibleCasing, Character.valueOf('B'), coreItems.circuitboards.get(EnumCircuitBoardType.BASIC));
        RecipeUtil.addRecipe("farm_nether", blocks.farmNether, "GTG", "TCT", "GBG", Character.valueOf('G'), "blockGlass", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.BLAZE, 1), Character.valueOf('C'), coreItems.flexibleCasing, Character.valueOf('B'), coreItems.circuitboards.get(EnumCircuitBoardType.BASIC));
        RecipeUtil.addRecipe("farm_ender", blocks.farmEnder, "GTG", "TCT", "GBG", Character.valueOf('G'), "blockGlass", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.ENDER, 1), Character.valueOf('C'), coreItems.flexibleCasing, Character.valueOf('B'), coreItems.circuitboards.get(EnumCircuitBoardType.BASIC));
        for (BlockPlanter planter : ModuleCultivation.getBlocks().getPlanters()) {
            RecipeUtil.addShapelessRecipe(((BlockTypePlanter)planter.blockType).func_176610_l() + "_manual_managed", planter.get(true), planter.get(false));
            RecipeUtil.addShapelessRecipe(((BlockTypePlanter)planter.blockType).func_176610_l() + "_managed_manual", planter.get(false), planter.get(true));
        }
    }
}

