/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.client.gui.CopyPasteGUI;
import com.direwolf20.buildinggadgets.client.gui.GuiButtonActionCallback;
import com.direwolf20.buildinggadgets.client.gui.GuiButtonSelect;
import com.direwolf20.buildinggadgets.client.gui.GuiSliderInt;
import com.direwolf20.buildinggadgets.client.gui.PasteGUI;
import com.direwolf20.buildinggadgets.common.ModSounds;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.network.PacketAnchor;
import com.direwolf20.buildinggadgets.common.network.PacketChangeRange;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.network.PacketToggleBlockPlacement;
import com.direwolf20.buildinggadgets.common.network.PacketToggleConnectedArea;
import com.direwolf20.buildinggadgets.common.network.PacketToggleFuzzy;
import com.direwolf20.buildinggadgets.common.network.PacketToggleMode;
import com.direwolf20.buildinggadgets.common.network.PacketToggleRayTraceFluid;
import com.direwolf20.buildinggadgets.common.network.PacketUndo;
import com.direwolf20.buildinggadgets.common.tools.BuildingModes;
import com.direwolf20.buildinggadgets.common.tools.ExchangingModes;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class ModeRadialMenu
extends GuiScreen {
    private static final ImmutableList<ResourceLocation> signsCopyPaste = ImmutableList.of((Object)new ResourceLocation("buildinggadgets", "textures/gui/mode/copy.png"), (Object)new ResourceLocation("buildinggadgets", "textures/gui/mode/paste.png"));
    private int timeIn = 0;
    private int slotSelected = -1;
    private int segments;
    private GuiSliderInt sliderRange;
    private final List<GuiButton> conditionalButtons = new ArrayList<GuiButton>();

    public ModeRadialMenu(ItemStack stack) {
        this.field_146297_k = Minecraft.func_71410_x();
        if (stack.func_77973_b() instanceof GadgetGeneric) {
            this.setSocketable(stack);
        }
    }

    public void setSocketable(ItemStack stack) {
        if (stack.func_77973_b() instanceof GadgetBuilding) {
            this.segments = BuildingModes.values().length;
        } else if (stack.func_77973_b() instanceof GadgetExchanger) {
            this.segments = ExchangingModes.values().length;
        } else if (stack.func_77973_b() instanceof GadgetCopyPaste) {
            this.segments = GadgetCopyPaste.ToolMode.values().length;
        }
    }

    public void func_73866_w_() {
        ScreenPosition left;
        this.conditionalButtons.clear();
        ItemStack tool = this.getGadget();
        boolean isDestruction = tool.func_77973_b() instanceof GadgetDestruction;
        ScreenPosition right = isDestruction ? ScreenPosition.TOP : ScreenPosition.RIGHT;
        ScreenPosition screenPosition = left = isDestruction ? ScreenPosition.BOTTOM : ScreenPosition.LEFT;
        if (isDestruction) {
            this.func_189646_b(new GuiButtonActionCallback("destroy.overlay", right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketChangeRange());
                }
                return GadgetDestruction.getOverlay(this.getGadget());
            }));
        } else {
            this.func_189646_b(new GuiButtonActionCallback("rotate", left, send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRotateMirror(PacketRotateMirror.Operation.ROTATE));
                }
                return false;
            }).setTogglable(false));
            this.func_189646_b(new GuiButtonActionCallback("mirror", left, send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRotateMirror(PacketRotateMirror.Operation.MIRROR));
                }
                return false;
            }).setTogglable(false));
        }
        if (!(tool.func_77973_b() instanceof GadgetCopyPaste)) {
            GuiButtonActionCallback button;
            if (!isDestruction || SyncedConfig.nonFuzzyEnabledDestruction) {
                button = new GuiButtonActionCallback("fuzzy", right, send -> {
                    if (send.booleanValue()) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleFuzzy());
                    }
                    return GadgetGeneric.getFuzzy(this.getGadget());
                });
                this.func_189646_b(button);
                this.conditionalButtons.add(button);
            }
            button = new GuiButtonActionCallback("connected_" + (isDestruction ? "area" : "surface"), right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleConnectedArea());
                }
                return GadgetGeneric.getConnectedArea(this.getGadget());
            });
            this.func_189646_b(button);
            this.conditionalButtons.add(button);
            if (!isDestruction) {
                int widthSlider = 82;
                this.sliderRange = new GuiSliderInt(this.field_146294_l / 2 - widthSlider / 2, this.field_146295_m / 2 + 72, widthSlider, 14, "Range ", "", 1.0, SyncedConfig.maxRange, GadgetUtils.getToolRange(tool), false, true, Color.DARK_GRAY, slider -> {
                    if (slider.getValueInt() != GadgetUtils.getToolRange(this.getGadget())) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketChangeRange(slider.getValueInt()));
                    }
                }, (slider, amount) -> {
                    int value = slider.getValueInt();
                    int valueNew = MathHelper.func_76125_a((int)(value + amount), (int)1, (int)SyncedConfig.maxRange);
                    slider.setValue(valueNew);
                    slider.updateSlider();
                });
                this.sliderRange.precision = 1;
                this.sliderRange.getComponents().forEach(arg_0 -> ((ModeRadialMenu)this).func_189646_b(arg_0));
            }
        } else {
            this.func_189646_b(new GuiButtonActionCallback("copypaste.opengui", right, send -> {
                if (!send.booleanValue()) {
                    return false;
                }
                this.field_146297_k.field_71439_g.func_71053_j();
                if (GadgetCopyPaste.getToolMode(tool) == GadgetCopyPaste.ToolMode.Copy) {
                    this.field_146297_k.func_147108_a((GuiScreen)new CopyPasteGUI(tool));
                } else {
                    this.field_146297_k.func_147108_a((GuiScreen)new PasteGUI(tool));
                }
                return true;
            }).setTogglable(false));
        }
        this.func_189646_b(new GuiButtonActionCallback("raytrace_fluid", right, send -> {
            if (send.booleanValue()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleRayTraceFluid());
            }
            return GadgetGeneric.shouldRayTraceFluid(this.getGadget());
        }));
        if (tool.func_77973_b() instanceof GadgetBuilding) {
            this.func_189646_b(new GuiButtonActionCallback("building.place_atop", right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleBlockPlacement());
                }
                return GadgetBuilding.shouldPlaceAtop(this.getGadget());
            }));
        }
        this.func_189646_b(new GuiButtonActionCallback("anchor", left, send -> {
            ItemStack stack;
            if (send.booleanValue()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAnchor());
            }
            if ((stack = this.getGadget()).func_77973_b() instanceof GadgetCopyPaste) {
                return GadgetCopyPaste.getAnchor(stack) != null;
            }
            if (stack.func_77973_b() instanceof GadgetDestruction) {
                return GadgetDestruction.getAnchor(stack) != null;
            }
            return !GadgetUtils.getAnchor(stack).isEmpty();
        }));
        if (!(tool.func_77973_b() instanceof GadgetExchanger)) {
            this.func_189646_b(new GuiButtonActionCallback("undo", left, send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUndo());
                }
                return false;
            }).setTogglable(false));
        }
        this.updateButtons(tool);
    }

    private void updateButtons(ItemStack tool) {
        GuiButtonActionCallback button;
        int posRight = 0;
        int posLeft = 0;
        int dim = 22;
        int padding = 10;
        boolean isDestruction = tool.func_77973_b() instanceof GadgetDestruction;
        ScreenPosition right = isDestruction ? ScreenPosition.BOTTOM : ScreenPosition.RIGHT;
        for (GuiButton guiButton : this.field_146292_n) {
            int offset;
            boolean isRight;
            if (!(guiButton instanceof GuiButtonActionCallback)) continue;
            button = (GuiButtonActionCallback)guiButton;
            SoundEvent sound = ModSounds.BEEP.getSound();
            button.setSounds(sound, sound, 1.0f, 0.6f);
            if (!button.field_146125_m) continue;
            boolean bl = isRight = button.getScreenPosition() == right;
            if (isRight) {
                posRight += dim + padding;
                offset = 70;
            } else {
                posLeft += dim + padding;
                offset = -70 - dim;
            }
            button.field_146120_f = dim;
            button.field_146121_g = dim;
            if (isDestruction) {
                button.field_146129_i = this.field_146295_m / 2 + (isRight ? 10 : -button.field_146121_g - 10);
                continue;
            }
            button.field_146128_h = this.field_146294_l / 2 + offset;
        }
        posRight = this.resetPos(tool, padding, posRight);
        posLeft = this.resetPos(tool, padding, posLeft);
        for (GuiButton guiButton : this.field_146292_n) {
            int pos;
            if (!(guiButton instanceof GuiButtonActionCallback)) continue;
            button = (GuiButtonActionCallback)guiButton;
            if (!button.field_146125_m) continue;
            boolean isRight = button.getScreenPosition() == right;
            int n = pos = isRight ? posRight : posLeft;
            if (isDestruction) {
                button.field_146128_h = pos;
            } else {
                button.field_146129_i = pos;
            }
            if (isRight) {
                posRight += dim + padding;
                continue;
            }
            posLeft += dim + padding;
        }
    }

    private int resetPos(ItemStack tool, int padding, int pos) {
        return tool.func_77973_b() instanceof GadgetDestruction ? this.field_146294_l / 2 - (pos - padding) / 2 : this.field_146295_m / 2 - (pos - padding) / 2;
    }

    private ItemStack getGadget() {
        return GadgetGeneric.getGadget((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public void func_73863_a(int mx, int my, float partialTicks) {
        ImmutableList<ResourceLocation> signs;
        int modeIndex;
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        int radiusMin = 26;
        int radiusMax = 60;
        double dist = new Vec3d((double)x, (double)y, 0.0).func_72438_d(new Vec3d((double)mx, (double)my, 0.0));
        boolean inRange = false;
        if (this.segments != 0) {
            inRange = dist > (double)radiusMin && dist < (double)radiusMax;
            for (GuiButton button : this.field_146292_n) {
                if (!(button instanceof GuiButtonActionCallback)) continue;
                ((GuiButtonActionCallback)button).setFaded(inRange);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((1.0f - fract) * (float)x), (float)((1.0f - fract) * (float)y), (float)0.0f);
        GlStateManager.func_179152_a((float)fract, (float)fract, (float)fract);
        super.func_73863_a(mx, my, partialTicks);
        GlStateManager.func_179121_F();
        if (this.segments == 0) {
            this.renderHoverHelpText(mx, my);
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        float angle = ModeRadialMenu.mouseAngle(x, y, mx, my);
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)this.segments;
        ArrayList<NameDisplayData> nameData = new ArrayList<NameDisplayData>();
        ItemStack tool = this.getGadget();
        if (tool.func_190926_b()) {
            return;
        }
        this.slotSelected = -1;
        float offset = 8.5f;
        if (tool.func_77973_b() instanceof GadgetBuilding) {
            modeIndex = GadgetBuilding.getToolMode(tool).ordinal();
            signs = BuildingModes.getIcons();
        } else if (tool.func_77973_b() instanceof GadgetExchanger) {
            modeIndex = GadgetExchanger.getToolMode(tool).ordinal();
            signs = ExchangingModes.getIcons();
        } else {
            modeIndex = GadgetCopyPaste.getToolMode(tool).ordinal();
            signs = signsCopyPaste;
        }
        boolean shouldCenter = (this.segments + 2) % 4 == 0;
        int indexBottom = this.segments / 4;
        int indexTop = indexBottom + this.segments / 2;
        for (int seg = 0; seg < this.segments; ++seg) {
            boolean mouseInSector = this.isCursorInSlice(angle, totalDeg, degPer, inRange);
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)this.segments) * 40.0f, (float)radiusMax));
            GL11.glBegin((int)5);
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs + (seg == modeIndex ? 1.0f : 0.0f);
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotSelected = seg;
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if ((int)i == (int)(degPer / 2.0f)) {
                    nameData.add(new NameDisplayData((int)xp, (int)yp, mouseInSector, shouldCenter && (seg == indexBottom || seg == indexTop)));
                }
                GL11.glVertex2d((double)((double)x + Math.cos(rad) * (double)radius / (double)2.3f), (double)((double)y + Math.sin(rad) * (double)radius / (double)2.3f));
                GL11.glVertex2d((double)xp, (double)yp);
            }
            totalDeg += degPer;
            GL11.glEnd();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        for (int i = 0; i < nameData.size(); ++i) {
            Color color;
            NameDisplayData data = (NameDisplayData)nameData.get(i);
            int xp = data.getX();
            int yp = data.getY();
            String name = tool.func_77973_b() instanceof GadgetBuilding ? BuildingModes.values()[i].toString() : (tool.func_77973_b() instanceof GadgetExchanger ? ExchangingModes.values()[i].toString() : GadgetCopyPaste.ToolMode.values()[i].toString());
            int xsp = xp - 4;
            int ysp = yp;
            int width = this.field_146289_q.func_78256_a(name);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            Color color2 = color = i == modeIndex ? Color.GREEN : Color.WHITE;
            if (data.isSelected()) {
                this.field_146289_q.func_175063_a(name, (float)(xsp + (data.isCentralized() ? width / 2 - 4 : 0)), (float)ysp, color.getRGB());
            }
            double mod = 0.7;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            this.field_146297_k.field_71446_o.func_110577_a((ResourceLocation)signs.get(i));
            GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.field_146297_k.field_71446_o.func_110577_a((ResourceLocation)signs.get(i));
            ModeRadialMenu.func_146110_a((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        float s = 2.25f * fract;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        GlStateManager.func_179109_b((float)((float)x / s - (tool.func_77973_b() instanceof GadgetCopyPaste ? 8.0f : 8.5f)), (float)((float)y / s - 8.0f), (float)0.0f);
        this.field_146297_k.func_175599_af().func_180450_b(tool, 0, 0);
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        this.renderHoverHelpText(mx, my);
    }

    private boolean isCursorInSlice(float angle, float totalDeg, float degPer, boolean inRange) {
        return inRange && angle > totalDeg && angle < totalDeg + degPer;
    }

    private void renderHoverHelpText(int mx, int my) {
        this.field_146292_n.forEach(button -> {
            if (!(button instanceof GuiButtonActionCallback)) {
                return;
            }
            GuiButtonActionCallback helpTextProvider = (GuiButtonActionCallback)button;
            if (helpTextProvider.isHovered(mx, my)) {
                Color color = button instanceof GuiButtonSelect && ((GuiButtonSelect)button).isSelected() ? Color.GREEN : Color.WHITE;
                String text = helpTextProvider.getHoverHelpText();
                int x = helpTextProvider.getScreenPosition() == ScreenPosition.LEFT ? mx - this.field_146289_q.func_78256_a(text) : mx;
                this.field_146289_q.func_175063_a(text, (float)x, (float)(my - this.field_146289_q.field_78288_b), color.getRGB());
            }
        });
    }

    private void changeMode() {
        if (this.slotSelected >= 0) {
            Item gadget = this.getGadget().func_77973_b();
            String mode = gadget instanceof GadgetBuilding ? BuildingModes.values()[this.slotSelected].toString() : (gadget instanceof GadgetExchanger ? ExchangingModes.values()[this.slotSelected].toString() : GadgetCopyPaste.ToolMode.values()[this.slotSelected].toString());
            this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + I18n.func_135052_a((String)"message.gadget.toolmode", (Object[])new Object[]{mode})), true);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleMode(this.slotSelected));
            ModSounds.BEEP.playSound();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.changeMode();
    }

    public void func_73876_c() {
        if (!GameSettings.func_100015_a((KeyBinding)KeyBindings.menuSettings)) {
            this.field_146297_k.func_147108_a(null);
            this.changeMode();
        }
        ImmutableSet set = ImmutableSet.of((Object)this.field_146297_k.field_71474_y.field_74351_w, (Object)this.field_146297_k.field_71474_y.field_74370_x, (Object)this.field_146297_k.field_71474_y.field_74368_y, (Object)this.field_146297_k.field_71474_y.field_74366_z, (Object)this.field_146297_k.field_71474_y.field_74311_E, (Object)this.field_146297_k.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_146297_k.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_74510_a((int)k.func_151463_i(), (boolean)GameSettings.func_100015_a((KeyBinding)k));
        }
        ++this.timeIn;
        ItemStack tool = this.getGadget();
        boolean builder = tool.func_77973_b() instanceof GadgetBuilding;
        if (!builder && !(tool.func_77973_b() instanceof GadgetExchanger)) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < this.conditionalButtons.size(); ++i) {
            boolean curent;
            GuiButton button = this.conditionalButtons.get(i);
            if (builder) {
                curent = GadgetBuilding.getToolMode(tool) == BuildingModes.Surface;
            } else {
                boolean bl = curent = i == 0 || GadgetExchanger.getToolMode(tool) == ExchangingModes.Surface;
            }
            if (button.field_146125_m == curent) continue;
            button.field_146125_m = curent;
            changed = true;
        }
        if (changed) {
            this.updateButtons(tool);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f((float)(mx - x), (float)(my - y));
        float ang = (float)(Math.acos(Vector2f.dot((Vector2f)baseVec, (Vector2f)mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }

    private static final class NameDisplayData {
        private final int x;
        private final int y;
        private final boolean selected;
        private final boolean centralize;

        private NameDisplayData(int x, int y, boolean selected, boolean centralize) {
            this.x = x;
            this.y = y;
            this.selected = selected;
            this.centralize = centralize;
        }

        private int getX() {
            return this.x;
        }

        private int getY() {
            return this.y;
        }

        private boolean isSelected() {
            return this.selected;
        }

        private boolean isCentralized() {
            return this.centralize;
        }
    }

    public static enum ScreenPosition {
        RIGHT,
        LEFT,
        BOTTOM,
        TOP;

    }
}

