/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.gen;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesHelper;
import galaxyspace.core.configs.GSConfigCore;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.math.MathHelper;

public abstract class WorldProviderAdvancedSpace
extends WorldProviderSpace
implements ISolarLevel,
IExitHeight,
IAdvancedSpace {
    protected BodiesData data = BodiesHelper.getData().get(this.getCelestialBody());

    public float getGravity() {
        return this.data.getGravityPlanet();
    }

    public float getThermalLevelModifier() {
        if (this.enableAdvancedThermalLevel()) {
            float angle = this.field_76579_a.func_72826_c((float)this.getDayLength());
            float value = MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * this.getThermalValueMod();
            float def = this.getCelestialBody().atmosphere.thermalLevel();
            if ((double)def < 0.0) {
                value *= -1.0f;
            }
            return def == 0.0f ? value : value * def + def;
        }
        return this.getCelestialBody().atmosphere.thermalLevel();
    }

    protected float getThermalValueMod() {
        return 0.5f;
    }

    public long getDayLength() {
        if (this.data == null) {
            return 24000L;
        }
        return this.data.getDayLengthPlanet();
    }

    @Override
    public int AtmosphericPressure() {
        return this.data.getPressurePlanet();
    }

    @Override
    public boolean SolarRadiation() {
        return this.data.getSolarRadiationPlanet();
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= this.getCelestialBody().getTierRequirement();
    }

    public float getSolarSizeForMoon() {
        return 1.0f / ((Moon)this.getCelestialBody()).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public double getSolarEnergyMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getCelestialBody() instanceof IChildBody ? (double)this.getSolarSizeForMoon() : (double)this.getSolarSize();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }

    @Override
    public double getSolarWindMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getCelestialBody() instanceof IChildBody ? (double)this.getSolarSizeForMoon() : (double)this.getSolarSize();
            solarMultiplier = s * s;
        }
        return solarMultiplier;
    }

    public double getYCoordinateToTeleport() {
        return 1000.0;
    }

    @Override
    public IAdvancedSpace.ClassBody getClassBody() {
        return IAdvancedSpace.ClassBody.SELENA;
    }

    public int func_76559_b(long time) {
        long timeday = this.getDayLength() > 0L ? this.getDayLength() : 1L;
        return (int)(time / timeday % 8L + 8L) % 8;
    }

    @Override
    public float getSolarRadiationModify() {
        return 1.0f;
    }

    public boolean enableAdvancedThermalLevel() {
        return GSConfigCore.enableAdvancedThermalSystem;
    }
}

