/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei.refinery;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class RefineryRecipeCategory
implements IRecipeCategory {
    private static final ResourceLocation refineryGuiTex = new ResourceLocation("galacticraftcore", "textures/gui/refinery_recipe.png");
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final IDrawableAnimated oilBar;
    @Nonnull
    private final IDrawableAnimated fuelBar;

    public RefineryRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(refineryGuiTex, 3, 4, 168, 64);
        this.localizedName = GCCoreUtil.translate("tile.refinery.name");
        IDrawableStatic progressBarDrawableOil = guiHelper.createDrawable(refineryGuiTex, 176, 0, 16, 38);
        this.oilBar = guiHelper.createAnimatedDrawable(progressBarDrawableOil, 70, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic progressBarDrawableFuel = guiHelper.createDrawable(refineryGuiTex, 192, 0, 16, 38);
        this.fuelBar = guiHelper.createAnimatedDrawable(progressBarDrawableFuel, 70, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return "galacticraft.refinery";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.oilBar.draw(minecraft, 40, 24);
        this.fuelBar.draw(minecraft, 114, 24);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemstacks = recipeLayout.getItemStacks();
        itemstacks.init(0, true, 39, 2);
        itemstacks.init(1, false, 113, 2);
        itemstacks.set(ingredients);
    }

    public String getModName() {
        return "Galacticraft Core";
    }
}

