/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.distribution;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.world.distribution.Distribution;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DistributionGaussian
extends Distribution {
    private final WorldGenerator worldGen;
    private final INumberProvider count;
    private final INumberProvider rolls;
    private final INumberProvider meanY;
    private final INumberProvider maxVar;

    public DistributionGaussian(String name, WorldGenerator worldGen, INumberProvider count, INumberProvider smoothness, INumberProvider meanY, INumberProvider maxVar, boolean regen) {
        super(name, regen);
        this.worldGen = worldGen;
        this.count = count;
        this.rolls = smoothness;
        this.meanY = meanY;
        this.maxVar = maxVar;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        INumberProvider.DataHolder data = new INumberProvider.DataHolder(pos);
        int count = this.count.intValue(world, random, data);
        this.worldGen.func_175904_e();
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int x = blockX + random.nextInt(16);
            int z = blockZ + random.nextInt(16);
            pos = new BlockPos(x, 64, z);
            int y = this.meanY.intValue(world, random, data.setPosition((Vec3i)pos));
            int maxVar = this.maxVar.intValue(world, random, data.setPosition((Vec3i)(pos = pos.func_177982_a(0, y - pos.func_177956_o(), 0))));
            if (maxVar > 1) {
                int rolls = this.rolls.intValue(world, random, data);
                for (int v = 0; v < rolls; ++v) {
                    y += random.nextInt(maxVar);
                }
                y = Math.round((float)y - (float)maxVar * ((float)rolls * 0.5f));
            }
            if (!this.canGenerateInBiome(world, x, z, random)) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

