/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing;

import com.google.common.collect.Lists;
import info.openmods.calc.Environment;
import info.openmods.calc.Frame;
import info.openmods.calc.executable.ExecutableList;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.Value;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.SameStateSymbolTransition;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.SymbolCallNode;
import java.util.ArrayList;
import java.util.List;

public class ConstantSymbolStateTransition<E>
extends SameStateSymbolTransition<IExprNode<E>> {
    private final String selfSymbol;
    private final Environment<E> env;

    public ConstantSymbolStateTransition(IParserState<IExprNode<E>> parentState, Environment<E> env, String selfSymbol) {
        super(parentState);
        this.env = env;
        this.selfSymbol = selfSymbol;
    }

    @Override
    public IExprNode<E> createRootNode(List<IExprNode<E>> children) {
        return new ConstantsNode(children);
    }

    private class ConstantsNode
    extends SymbolCallNode<E> {
        public ConstantsNode(List<IExprNode<E>> constants) {
            super(ConstantSymbolStateTransition.this.selfSymbol, constants);
        }

        @Override
        public void flatten(List<IExecutable<E>> output) {
            ArrayList ops = Lists.newArrayList();
            for (IExprNode child : this.getChildren()) {
                child.flatten(ops);
            }
            Frame resultFrame = ConstantSymbolStateTransition.this.env.executeIsolated(ExecutableList.wrap(ops));
            for (Object constant : resultFrame.stack()) {
                output.add(Value.create(constant));
            }
        }
    }
}

