/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.compat.minecraft;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.oredict.OreDictionary;
import vswe.stevescarts.api.farms.EnumHarvestResult;
import vswe.stevescarts.api.farms.ITreeModule;
import vswe.stevescarts.entitys.EntityMinecartModular;

public class DefaultTreeModule
implements ITreeModule {
    @Override
    public EnumHarvestResult isLeaves(IBlockState blockState, BlockPos pos, EntityMinecartModular cart) {
        return blockState.func_177230_c().isLeaves(blockState, (IBlockAccess)cart.field_70170_p, pos) ? EnumHarvestResult.ALLOW : EnumHarvestResult.SKIP;
    }

    @Override
    public EnumHarvestResult isWood(IBlockState blockState, BlockPos pos, EntityMinecartModular cart) {
        return blockState.func_177230_c().isWood((IBlockAccess)cart.field_70170_p, pos) ? EnumHarvestResult.ALLOW : EnumHarvestResult.SKIP;
    }

    @Override
    public boolean isSapling(@Nonnull ItemStack sapling) {
        if (!sapling.func_190926_b()) {
            if (this.isStackSapling(sapling)) {
                return true;
            }
            if (sapling.func_77973_b() instanceof ItemBlock) {
                Block b = Block.func_149634_a((Item)sapling.func_77973_b());
                return b instanceof BlockSapling || b != null && this.isStackSapling(new ItemStack(b, 1, Short.MAX_VALUE));
            }
        }
        return false;
    }

    @Override
    public boolean plantSapling(World world, BlockPos pos, ItemStack stack, FakePlayer fakePlayer) {
        BlockSapling blockSapling;
        if (stack.func_190926_b()) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block instanceof BlockSapling && (blockSapling = (BlockSapling)block).func_176196_c(world, pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), blockSapling.func_176203_a(stack.func_77952_i()));
            return true;
        }
        return false;
    }

    private boolean isStackSapling(@Nonnull ItemStack sapling) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)sapling)) {
            String name = OreDictionary.getOreName((int)id);
            if (name == null || !name.startsWith("treeSapling")) continue;
            return true;
        }
        return false;
    }
}

