/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.thread.ThreadSmallExplosion;
import icbm.classic.lib.PosDistanceSorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlastAntiGravitational
extends Blast {
    protected ThreadSmallExplosion thread;
    protected Set<EntityFlyingBlock> flyingBlocks = new HashSet<EntityFlyingBlock>();

    public BlastAntiGravitational(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.world().field_72995_K) {
            this.thread = new ThreadSmallExplosion(this, (int)this.getBlastRadius(), this.field_77283_e);
            this.thread.start();
        }
    }

    @Override
    public void doExplode() {
        int r = this.callCount;
        if (this.world() != null && !this.world().field_72995_K) {
            try {
                if (this.thread != null) {
                    if (this.thread.isComplete) {
                        ArrayList results = new ArrayList();
                        results.addAll(this.getThreadResults());
                        if (r == 0) {
                            Collections.sort(results, new PosDistanceSorter(this.location, true));
                        }
                        int blocksToTake = 20;
                        for (BlockPos targetPosition : results) {
                            float hardness;
                            IBlockState blockState = this.field_77287_j.func_180495_p(targetPosition);
                            if (blockState.func_177230_c() == Blocks.field_150350_a || !((hardness = blockState.func_185887_b(this.field_77287_j, targetPosition)) >= 0.0f) || !(hardness < 1000.0f) || this.world().field_73012_v.nextInt(3) <= 0) continue;
                            this.field_77287_j.func_175698_g(targetPosition);
                            if (--blocksToTake > 0) {
                                EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), targetPosition, blockState, 0.0f);
                                entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                                entity.pitchChange = 100.0f * this.world().field_73012_v.nextFloat();
                                entity.field_70181_x += Math.max(0.15 * (double)this.world().field_73012_v.nextFloat(), 0.1);
                                entity.field_70145_X = true;
                                this.world().func_72838_d((Entity)entity);
                                this.flyingBlocks.add(entity);
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    String msg = String.format("BlastAntiGravitational#doPostExplode() -> Failed to run due to null thread\nWorld = %s \nThread = %s\nSize = %s\nPos = ", this.field_77287_j, this.thread, Float.valueOf(this.field_77280_f), this.location);
                    ICBMClassic.logger().error(msg);
                }
            }
            catch (Exception e) {
                String msg = String.format("BlastAntiGravitational#doPostExplode() ->  Unexpected error while running post detonation code \nWorld = %s \nThread = %s\nSize = %s\nPos = ", this.field_77287_j, this.thread, Float.valueOf(this.field_77280_f), this.location);
                ICBMClassic.logger().error(msg, (Throwable)e);
            }
        }
        int radius = (int)this.getBlastRadius();
        AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - (double)radius, this.location.y() - (double)radius, this.location.z() - (double)radius, this.location.y() + (double)radius, 100.0, this.location.z() + (double)radius);
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        for (Entity entity : allEntities) {
            if (entity instanceof EntityFlyingBlock || !(entity.field_70163_u < 100.0 + this.location.y()) || !(entity.field_70181_x < 0.4)) continue;
            entity.field_70181_x += 0.15;
        }
        if (this.callCount > 2400) {
            this.controller.endExplosion();
        }
    }

    @Override
    protected void doPostExplode() {
        for (EntityFlyingBlock entity : this.flyingBlocks) {
            entity.gravity = 0.045f;
        }
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public float getBlastRadius() {
        return 15.0f;
    }
}

