/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast.threaded;

import icbm.classic.client.ICBMSounds;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.explosive.blast.BlastRedmatter;
import icbm.classic.content.explosive.blast.threaded.BlastThreaded;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastAntimatter
extends BlastThreaded {
    private boolean destroyBedrock;

    public BlastAntimatter(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastAntimatter(World world, Entity entity, double x, double y, double z, float size, boolean destroyBedrock) {
        this(world, entity, x, y, z, size);
        this.destroyBedrock = destroyBedrock;
    }

    @Override
    public void doPreExplode() {
        super.doPreExplode();
        ICBMSounds.ANTIMATTER.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 7.0f, (float)((double)this.world().field_73012_v.nextFloat() * 0.1 + (double)0.9f), true);
        this.doDamageEntities(this.getBlastRadius() * 2.0f, 2.1474836E9f);
    }

    @Override
    public void destroyBlock(BlockPos blockPos) {
        double dist;
        IBlockState blockState = this.field_77287_j.func_180495_p(blockPos);
        if (!blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.field_77287_j, blockPos) && ((dist = this.location.distance((Vec3i)blockPos)) < (double)(this.getBlastRadius() - 1.0f) || (double)this.world().field_73012_v.nextFloat() > 0.7) && (blockState.func_185887_b(this.world(), blockPos) >= 0.0f || this.destroyBedrock)) {
            this.field_77287_j.func_175698_g(blockPos);
        }
    }

    @Override
    public boolean doRun(int loops, List<BlockPos> edits) {
        int x = (int)(-this.getBlastRadius());
        while ((float)x < this.getBlastRadius()) {
            int y = (int)(-this.getBlastRadius());
            while ((float)y < this.getBlastRadius()) {
                int z = (int)(-this.getBlastRadius());
                while ((float)z < this.getBlastRadius()) {
                    BlockPos blockPos = new BlockPos(this.location.xi() + x, this.location.yi() + y, this.location.zi() + z);
                    double dist = this.location.distance((Vec3i)blockPos);
                    if (dist < (double)this.getBlastRadius()) {
                        edits.add(blockPos);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    @Override
    public void doExplode() {
        super.doExplode();
    }

    @Override
    public void doPostExplode() {
        super.doPostExplode();
        this.doDamageEntities(this.getBlastRadius() * 2.0f, 2.1474836E9f);
    }

    @Override
    protected boolean onDamageEntity(Entity entity) {
        if (entity instanceof EntityExplosion && ((EntityExplosion)entity).getBlast() instanceof BlastRedmatter) {
            entity.func_70106_y();
            return true;
        }
        return false;
    }
}

