/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.thread2;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class BlockEditHandler {
    public static final HashMap<Integer, Queue<EditQueue>> worldToRemoveQueue = new HashMap();
    public static int blockEditsPerTick = 10000;
    public static int blockEditsPerQueue = 100;

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        if (worldToRemoveQueue.containsKey(dim)) {
            worldToRemoveQueue.remove(dim);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        int dim = event.world.field_73011_w.getDimension();
        if (worldToRemoveQueue.containsKey(dim)) {
            int editsLeft = blockEditsPerTick;
            Queue<EditQueue> list = worldToRemoveQueue.get(dim);
            if (list.peek() != null) {
                int limitPerQueue = Math.max(blockEditsPerQueue, blockEditsPerTick / list.size());
                while (editsLeft > 0 && list.peek() != null) {
                    EditQueue queue = list.peek();
                    if (queue != null) {
                        editsLeft -= queue.doWork(limitPerQueue);
                        if (!queue.isDone()) continue;
                        list.poll();
                        continue;
                    }
                    list.poll();
                }
            }
        }
    }

    public static void queue(World world, Collection<BlockPos> edits, Consumer<BlockPos> onEditBlock) {
        int dim = world.field_73011_w.getDimension();
        if (!worldToRemoveQueue.containsKey(dim)) {
            worldToRemoveQueue.put(dim, new LinkedList());
        }
        worldToRemoveQueue.get(dim).add(new EditQueue(edits, onEditBlock));
    }

    public static class EditQueue {
        public final Queue<BlockPos> queue = new LinkedList<BlockPos>();
        public final Consumer<BlockPos> onEditBlock;

        public EditQueue(Collection<BlockPos> edits, Consumer<BlockPos> onEditBlock) {
            this.queue.addAll(edits);
            this.onEditBlock = onEditBlock;
        }

        public int doWork(int limit) {
            int edits;
            for (edits = 0; edits <= limit && !this.isDone(); ++edits) {
                this.onEditBlock.accept(this.queue.poll());
            }
            return edits;
        }

        public boolean isDone() {
            return this.queue.peek() == null;
        }
    }
}

