/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.packet;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.ex.PacketTileReadException;
import icbm.classic.lib.network.packet.PacketBase;
import icbm.classic.lib.transform.vector.Location;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketTile
extends PacketBase<PacketTile> {
    public int x;
    public int y;
    public int z;
    public int id;
    public String name;

    public PacketTile() {
    }

    public PacketTile(String name, int id, int x, int y, int z) {
        this.name = name;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketTile(String name, int id, TileEntity tile) {
        this(name, id, tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p());
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBoolean(ICBMClassic.runningAsDev);
        if (ICBMClassic.runningAsDev) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        }
        buffer.writeInt(this.id);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        super.encodeInto(ctx, buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        this.id = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        super.decodeInto(ctx, buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("PacketTile#handleClientSide(null) - player was null for packet", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("PacketTile#handleServerSide(null) - player was null for packet", (Throwable)new RuntimeException());
        }
    }

    public void handle(EntityPlayer player) {
        if (player.func_130014_f_() == null) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("PacketTile#handle(" + player + ") - world is null for player while handling packet. ", (Throwable)new RuntimeException());
            }
            return;
        }
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        if (player.func_130014_f_().func_175667_e(pos)) {
            this.handle(player, player.func_130014_f_().func_175625_s(pos));
        } else if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("PacketTile#handle(" + player + ") - block is not loaded for player while handling packet. ", (Throwable)new RuntimeException());
        }
    }

    public void handle(EntityPlayer player, TileEntity tile) {
        Location location = new Location(player.field_70170_p, this.x, this.y, this.z);
        if (tile == null) {
            ICBMClassic.logger().error((Object)new PacketTileReadException(location, "Null tile"));
        } else if (tile.func_145837_r()) {
            ICBMClassic.logger().error((Object)new PacketTileReadException(location, "Invalidated tile"));
        } else if (tile instanceof IPacketIDReceiver) {
            if (((IPacketIDReceiver)tile).shouldReadPacket(player, location, this)) {
                try {
                    IPacketIDReceiver receiver = (IPacketIDReceiver)tile;
                    receiver.read(this.dataToRead, this.id, player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    ICBMClassic.logger().error((Object)new PacketTileReadException(location, "Packet was read past it's size."));
                    ICBMClassic.logger().error("Error: ", (Throwable)e);
                }
                catch (NullPointerException e) {
                    ICBMClassic.logger().error((Object)new PacketTileReadException(location, "Null pointer while reading data", e));
                    ICBMClassic.logger().error("Error: ", (Throwable)e);
                }
                catch (Exception e) {
                    ICBMClassic.logger().error((Object)new PacketTileReadException(location, "Failed to read packet", e));
                    ICBMClassic.logger().error("Error: ", (Throwable)e);
                }
            } else {
                ICBMClassic.logger().error("Error: " + tile + " rejected packet " + this + " due to invalid conditions.");
            }
        } else {
            ICBMClassic.logger().error((Object)new PacketTileReadException(location, "Unsupported action for " + tile));
        }
    }
}

