/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.tileentity;

import gcewing.sg.SGCraft;
import gcewing.sg.tileentity.PowerTE;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class SGPowerTE
extends PowerTE
implements IEnergyStorage {
    public SGPowerTE() {
        super(SGCraft.FPMaxEnergyBuffer, SGCraft.FPPerSGEnergyUnit);
    }

    @Override
    public String getScreenTitle() {
        return "SGPU";
    }

    @Override
    public String getUnitName() {
        return "SG";
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbttagcompound) {
        super.readContentsFromNBT(nbttagcompound);
        if (SGCraft.forceFPCfgUpdate) {
            this.energyMax = SGCraft.FPMaxEnergyBuffer;
            this.energyPerSGEnergyUnit = SGCraft.FPPerSGEnergyUnit;
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return null;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min((int)Math.floor(this.energyMax - this.energyBuffer), maxReceive);
        if (!simulate) {
            this.energyBuffer += (double)energyReceived;
        }
        this.markChanged();
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (int)Math.floor(this.energyBuffer);
    }

    public int getMaxEnergyStored() {
        return (int)Math.floor(this.energyMax);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public double totalAvailableEnergy() {
        return this.energyBuffer;
    }
}

