/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import net.minecraft.util.ResourceLocation;

class ResourceLocationDeserializer
implements JsonDeserializer<ResourceLocation> {
    ResourceLocationDeserializer() {
    }

    public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object;
        ResourceLocation location = null;
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isString()) {
                location = new ResourceLocation(primitive.getAsString());
            }
        } else if (json.isJsonObject() && (object = json.getAsJsonObject()).has("domain") && object.has("path")) {
            String domain = object.getAsJsonPrimitive("domain").getAsString();
            String path = object.getAsJsonPrimitive("path").getAsString();
            location = new ResourceLocation(domain, path);
        }
        if (location == null) {
            throw new JsonParseException("Invalid element for resource location");
        }
        return location;
    }
}

