/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.cs4.plugins.vanilla.crafting.MachineFuel;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipe;
import cubex2.cs4.plugins.vanilla.crafting.VanillaFurnaceFuel;
import cubex2.cs4.plugins.vanilla.crafting.VanillaFurnaceRecipe;
import cubex2.cs4.util.ItemHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class MachineManager {
    private static final Map<ResourceLocation, MachineManager> instances = Maps.newHashMap();
    private final List<MachineRecipe> recipes = Lists.newArrayList();
    private final List<MachineFuel> fuels = Lists.newArrayList();

    public static MachineManager getInstance(ResourceLocation list) {
        if (!instances.containsKey(list)) {
            instances.put(list, new MachineManager());
        }
        return instances.get(list);
    }

    public static List<MachineRecipe> getRecipes(ResourceLocation list) {
        if (list.toString().equals("minecraft:vanilla")) {
            throw new UnsupportedOperationException();
        }
        return MachineManager.getInstance((ResourceLocation)list).recipes;
    }

    public static void addRecipe(ResourceLocation list, MachineRecipe recipe) {
        MachineManager.getRecipes(list).add(recipe);
    }

    public static boolean isPartOfRecipe(ResourceLocation list, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (list.toString().equals("minecraft:vanilla")) {
            return !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
        }
        for (MachineRecipe recipe : MachineManager.getInstance((ResourceLocation)list).recipes) {
            if (!recipe.getRecipeInput().stream().anyMatch(input -> ItemHelper.stackMatchesRecipeInput(stack, input, false))) continue;
            return true;
        }
        return false;
    }

    public static MachineRecipe findMatchingRecipe(ResourceLocation list, NonNullList<ItemStack> input, List<FluidStack> inputFluid, World worldIn) {
        if (list.toString().equals("minecraft:vanilla")) {
            if (input.size() == 1 && !((ItemStack)input.get(0)).func_190926_b()) {
                return new VanillaFurnaceRecipe(FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)input.get(0)));
            }
            return MachineRecipe.EMPTY;
        }
        return MachineManager.findMatchingRecipe(MachineManager.getRecipes(list), input, inputFluid, worldIn);
    }

    public static MachineRecipe findMatchingRecipe(List<MachineRecipe> recipes, NonNullList<ItemStack> input, List<FluidStack> inputFluid, World worldIn) {
        for (MachineRecipe recipe : recipes) {
            if (input.size() != recipe.getInputStacks() || inputFluid.size() != recipe.getFluidStacks() || !recipe.matches(input, inputFluid, worldIn)) continue;
            return recipe;
        }
        return MachineRecipe.EMPTY;
    }

    public static void addFuel(ResourceLocation list, MachineFuel fuel) {
        if (list.toString().equals("minecraft:vanilla")) {
            throw new UnsupportedOperationException();
        }
        MachineManager.getInstance((ResourceLocation)list).fuels.add(fuel);
    }

    public static MachineFuel findMatchingFuel(ResourceLocation list, NonNullList<ItemStack> input) {
        if (list.toString().equals("minecraft:vanilla")) {
            ItemStack stack;
            int burnTime;
            if (input.size() == 1 && !((ItemStack)input.get(0)).func_190926_b() && (burnTime = TileEntityFurnace.func_145952_a((ItemStack)(stack = (ItemStack)input.get(0)))) > 0) {
                return new VanillaFurnaceFuel(stack, burnTime);
            }
            return MachineFuel.EMPTY;
        }
        return MachineManager.findMatchingFuel(MachineManager.getInstance((ResourceLocation)list).fuels, input);
    }

    public static MachineFuel findMatchingFuel(List<MachineFuel> fuels, NonNullList<ItemStack> input) {
        for (MachineFuel fuel : fuels) {
            if (input.size() != fuel.getFuelInput().size() || !fuel.matches(input)) continue;
            return fuel;
        }
        return MachineFuel.EMPTY;
    }

    public static boolean isPartOfFuel(ResourceLocation list, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (list.toString().equals("minecraft:vanilla")) {
            return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
        }
        for (MachineFuel fuel : MachineManager.getInstance((ResourceLocation)list).fuels) {
            if (!fuel.getFuelInput().stream().anyMatch(input -> ItemHelper.stackMatchesRecipeInput(stack, input, false))) continue;
            return true;
        }
        return false;
    }
}

