/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.model.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.machinemuse.numina.client.model.helper.MuseModelHelper;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.powersuits.client.model.helper.ColoredQuadHelperThingie;
import net.machinemuse.powersuits.common.MPSItems;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum ModelLuxCapacitorHelper {
    INSTANCE;

    private static final ResourceLocation baseModelLocation;
    private static final ResourceLocation lensModelLocation;
    public static LoadingCache<ColoredQuadHelperThingie, List<BakedQuad>> luxCapColoredQuadMap;

    static {
        baseModelLocation = new ResourceLocation("powersuits:block/luxcapacitor/luxcapacitor_base.obj");
        lensModelLocation = new ResourceLocation("powersuits:block/luxcapacitor/luxcapacitor_lens.obj");
        luxCapColoredQuadMap = CacheBuilder.newBuilder().maximumSize(40L).build((CacheLoader)new CacheLoader<ColoredQuadHelperThingie, List<BakedQuad>>(){

            public List<BakedQuad> load(ColoredQuadHelperThingie key) throws Exception {
                return this.getQuads(key.getColour(), key.getFacing());
            }

            public IBakedModel getBase(@Nullable EnumFacing facing) {
                return MuseModelHelper.getBakedModel((ResourceLocation)baseModelLocation, (IModelState)TRSRTransformation.from((EnumFacing)(facing != null ? facing : EnumFacing.NORTH)));
            }

            public IBakedModel getLens(@Nullable EnumFacing facing) {
                return MuseModelHelper.getBakedModel((ResourceLocation)lensModelLocation, (IModelState)TRSRTransformation.from((EnumFacing)(facing != null ? facing : EnumFacing.NORTH)));
            }

            List<BakedQuad> getBaseQuads(@Nullable EnumFacing facing) {
                facing = facing != null ? facing : EnumFacing.NORTH;
                TRSRTransformation transform = TRSRTransformation.from((EnumFacing)facing);
                IBakedModel bakedModel = MuseModelHelper.getBakedModel((ResourceLocation)baseModelLocation, (IModelState)transform);
                return bakedModel.func_188616_a(MPSItems.luxCapacitor.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)facing), null, 0L);
            }

            List<BakedQuad> getLensColoredQuads(Colour color, @Nullable EnumFacing facing) {
                facing = facing != null ? facing : EnumFacing.NORTH;
                TRSRTransformation transform = TRSRTransformation.from((EnumFacing)facing);
                IBakedModel bakedModel = MuseModelHelper.getBakedModel((ResourceLocation)lensModelLocation, (IModelState)transform);
                List quads = bakedModel.func_188616_a(MPSItems.luxCapacitor.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)facing), null, 0L);
                return MuseModelHelper.getColoredQuadsWithGlow((List)quads, (Colour)color, (boolean)true);
            }

            List<BakedQuad> getQuads(Colour color, @Nullable EnumFacing facing) {
                List<BakedQuad> frameList = this.getBaseQuads(facing);
                List<BakedQuad> lensList = this.getLensColoredQuads(color, facing);
                ImmutableList.Builder builder = ImmutableList.builder();
                for (BakedQuad quad : frameList) {
                    builder.add((Object)quad);
                }
                for (BakedQuad quad : lensList) {
                    builder.add((Object)quad);
                }
                return builder.build();
            }
        });
    }
}

