/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.client.gui.slots.SlotInput;
import reborncore.client.gui.slots.SlotOutput;
import reborncore.common.container.RebornContainer;

public class InventoryItemHandler
implements IItemHandler {
    private final EnumFacing facing;
    private Map<EnumFacing, List<BaseSlot>> slotMap = new HashMap<EnumFacing, List<BaseSlot>>();
    private int slotLimit = 64;

    public InventoryItemHandler(RebornContainer container, EnumFacing facing) {
        this.facing = facing;
        for (EnumFacing _facing : EnumFacing.field_82609_l) {
            ArrayList<BaseSlot> slotList = new ArrayList<BaseSlot>();
            for (Map.Entry<Integer, BaseSlot> entry : container.slotMap.entrySet()) {
                BaseSlot baseSlot = entry.getValue();
                if (_facing == EnumFacing.UP && baseSlot instanceof SlotInput) {
                    slotList.add(baseSlot);
                    continue;
                }
                if (_facing == EnumFacing.DOWN && baseSlot instanceof SlotOutput) {
                    slotList.add(baseSlot);
                    continue;
                }
                slotList.add(baseSlot);
            }
            this.slotMap.put(_facing, slotList);
        }
    }

    public int getSlots() {
        return this.slotMap.get(this.facing).size();
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return this.slotMap.get(this.facing).get(slotIndex).func_75211_c();
    }

    public ItemStack insertItem(int slotIndex, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        Slot slot = this.slotMap.get(this.facing).get(slotIndex);
        if (!slot.func_75216_d()) {
            slot.func_75215_d(stack);
            return ItemStack.field_190927_a;
        }
        ItemStack existing = slot.func_75211_c();
        int limit = slot.func_75219_a();
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                slot.func_75215_d(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190920_e(reachedLimit ? limit : stack.func_190916_E());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slotIndex, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        Slot slot = this.slotMap.get(this.facing).get(slotIndex);
        if (slot.func_75211_c().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = slot.func_75211_c();
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }
}

