/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.util.helpers.StringHelper;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.init.PotionTypes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidPotion
extends Fluid {
    public static int DEFAULT_COLOR = 0xF800F8;
    private final String prefix;

    public FluidPotion(String fluidName, String modName, String prefix) {
        super(fluidName, new ResourceLocation(modName, "blocks/fluid/potion_still"), new ResourceLocation(modName, "blocks/fluid/potion_flow"));
        this.prefix = prefix;
    }

    public int getColor() {
        return 0xFF000000 | DEFAULT_COLOR;
    }

    public int getColor(FluidStack stack) {
        return 0xFF000000 | FluidPotion.getPotionColor(stack);
    }

    public String getLocalizedName(FluidStack stack) {
        PotionType type = PotionUtils.func_185187_c((NBTTagCompound)stack.tag);
        if (type == PotionTypes.field_185229_a || type == PotionTypes.field_185230_b) {
            return super.getLocalizedName(stack);
        }
        return StringHelper.localize((String)type.func_185174_b(this.prefix));
    }

    public static int getPotionColor(FluidStack stack) {
        if (stack.tag != null && stack.tag.func_150297_b("CustomPotionColor", 99)) {
            return stack.tag.func_74762_e("CustomPotionColor");
        }
        return FluidPotion.getPotionTypeFromNBT(stack.tag) == PotionTypes.field_185229_a ? DEFAULT_COLOR : PotionUtils.func_185181_a((Collection)PotionUtils.func_185185_a((NBTTagCompound)stack.tag));
    }

    public static PotionType getPotionTypeFromNBT(@Nullable NBTTagCompound tag) {
        return tag == null || !tag.func_74764_b("Potion") ? PotionTypes.field_185229_a : PotionType.func_185168_a((String)tag.func_74779_i("Potion"));
    }
}

