/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlaySensorGlasses;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class FootprintRenderer {
    public static Map<Long, List<Footprint>> footprints = new ConcurrentHashMap<Long, List<Footprint>>();
    private static final ResourceLocation footprintTexture = new ResourceLocation("galacticraftcore", "textures/misc/footprint.png");

    public static void renderFootprints(EntityPlayer player, float partialTicks) {
        int dimActive = GCCoreUtil.getDimensionID(player.field_70170_p);
        LinkedList<Footprint> footprintsToDraw = new LinkedList<Footprint>();
        for (List<Footprint> footprintList : footprints.values()) {
            for (Footprint footprint : footprintList) {
                if (footprint.dimension != dimActive) continue;
                footprintsToDraw.add(footprint);
            }
        }
        if (footprintsToDraw.isEmpty()) {
            return;
        }
        GlStateManager.func_179094_E();
        double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(footprintTexture);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.func_178181_a();
        float f7 = 1.0f;
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = 1.0f;
        float f10 = 0.4f;
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        boolean sensorGlasses = OverlaySensorGlasses.overrideMobTexture();
        if (sensorGlasses) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Footprint footprint : footprintsToDraw) {
            GL11.glPushMatrix();
            if (!sensorGlasses) {
                int j = footprint.lightmapVal % 65536;
                int k = footprint.lightmapVal / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            }
            float ageScale = (float)footprint.age / 3200.0f;
            BufferBuilder worldRenderer = tessellator.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float f11 = (float)(footprint.position.x - interpPosX);
            float f12 = (float)(footprint.position.y - interpPosY) + 0.001f;
            float f13 = (float)(footprint.position.z - interpPosZ);
            GL11.glTranslatef((float)f11, (float)f12, (float)f13);
            int brightness = (int)(100.0f + ageScale * 155.0f);
            GlStateManager.func_179131_c((float)(1.0f - ageScale), (float)(1.0f - ageScale), (float)(1.0f - ageScale), (float)(1.0f - ageScale));
            double footprintScale = 0.5;
            worldRenderer.func_181662_b(Math.sin((double)(45.0f - footprint.rotation) / 57.29577951308232) * footprintScale, 0.0, Math.cos((double)(45.0f - footprint.rotation) / 57.29577951308232) * footprintScale).func_187315_a((double)f7, (double)f9).func_181675_d();
            worldRenderer.func_181662_b(Math.sin((double)(135.0f - footprint.rotation) / 57.29577951308232) * footprintScale, 0.0, Math.cos((double)(135.0f - footprint.rotation) / 57.29577951308232) * footprintScale).func_187315_a((double)f7, (double)f8).func_181675_d();
            worldRenderer.func_181662_b(Math.sin((double)(225.0f - footprint.rotation) / 57.29577951308232) * footprintScale, 0.0, Math.cos((double)(225.0f - footprint.rotation) / 57.29577951308232) * footprintScale).func_187315_a((double)f6, (double)f8).func_181675_d();
            worldRenderer.func_181662_b(Math.sin((double)(315.0f - footprint.rotation) / 57.29577951308232) * footprintScale, 0.0, Math.cos((double)(315.0f - footprint.rotation) / 57.29577951308232) * footprintScale).func_187315_a((double)f6, (double)f9).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        if (sensorGlasses) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        }
        GlStateManager.func_179121_F();
    }

    public static void addFootprint(long chunkKey, Footprint footprint) {
        List<Footprint> footprintList = footprints.get(chunkKey);
        if (footprintList == null) {
            footprintList = new ArrayList<Footprint>();
        }
        footprintList.add(new Footprint(footprint.dimension, footprint.position, footprint.rotation, footprint.owner, footprint.lightmapVal));
        footprints.put(chunkKey, footprintList);
    }

    public static void addFootprint(long chunkKey, int dimension, Vector3 position, float rotation, String owner, int lightmapVal) {
        FootprintRenderer.addFootprint(chunkKey, new Footprint(dimension, position, rotation, owner, lightmapVal));
    }

    public static void setFootprints(long chunkKey, List<Footprint> prints) {
        List<Footprint> footprintList = footprints.get(chunkKey);
        if (footprintList == null) {
            footprintList = new ArrayList<Footprint>();
        }
        Iterator<Footprint> i = footprintList.iterator();
        while (i.hasNext()) {
            Footprint print = i.next();
            if (print.owner.equals(FMLClientHandler.instance().getClient().field_71439_g.func_70005_c_())) continue;
            i.remove();
        }
        footprintList.addAll(prints);
        footprints.put(chunkKey, footprintList);
    }
}

