/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.fluid;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class NetworkHelper {
    public static EnumSet<EnumFacing> getDirections(TileEntity tileEntity, NetworkType type) {
        EnumSet<EnumFacing> possibleSides = EnumSet.noneOf(EnumFacing.class);
        if (tileEntity instanceof IConnector) {
            for (int i = 0; i < 6; ++i) {
                EnumFacing direction = EnumFacing.func_82600_a((int)i);
                if (!((IConnector)tileEntity).canConnect(direction, type)) continue;
                possibleSides.add(direction);
            }
        }
        return possibleSides;
    }

    public static Set<IElectricityNetwork> getNetworksFromMultipleSides(TileEntity tileEntity, EnumSet<EnumFacing> approachingDirection) {
        HashSet<IElectricityNetwork> connectedNetworks = new HashSet<IElectricityNetwork>();
        BlockVec3 tileVec = new BlockVec3(tileEntity);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity outputConductor;
            IElectricityNetwork electricityNetwork;
            if (!approachingDirection.contains(side) || (electricityNetwork = NetworkHelper.getElectricalNetworkFromTileEntity(outputConductor = tileVec.getTileEntityOnSide(tileEntity.func_145831_w(), side), side)) == null) continue;
            connectedNetworks.add(electricityNetwork);
        }
        return connectedNetworks;
    }

    public static IElectricityNetwork getElectricalNetworkFromTileEntity(TileEntity tileEntity, EnumFacing approachDirection) {
        if (tileEntity != null && tileEntity instanceof INetworkProvider && (tileEntity instanceof IConnector ? ((IConnector)tileEntity).canConnect(approachDirection.func_176734_d(), NetworkType.POWER) && ((INetworkProvider)tileEntity).getNetwork() instanceof IElectricityNetwork : ((INetworkProvider)tileEntity).getNetwork() instanceof IElectricityNetwork)) {
            return (IElectricityNetwork)((INetworkProvider)tileEntity).getNetwork();
        }
        return null;
    }

    public static FluidNetwork getFluidNetworkFromTile(TileEntity tileEntity, EnumFacing approachDirection) {
        if (tileEntity != null && tileEntity instanceof INetworkProvider && (tileEntity instanceof IConnector ? ((IConnector)tileEntity).canConnect(approachDirection.func_176734_d(), NetworkType.FLUID) && ((INetworkProvider)tileEntity).getNetwork() instanceof FluidNetwork : ((INetworkProvider)tileEntity).getNetwork() instanceof FluidNetwork)) {
            return (FluidNetwork)((INetworkProvider)tileEntity).getNetwork();
        }
        return null;
    }
}

