/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.item;

import cofh.api.fluid.IFluidContainerItem;
import cofh.api.item.IColorableItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.util.capabilities.FluidContainerItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.fluid.FluidPotion;
import cofh.thermalfoundation.init.TFFluids;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemMultiPotion
extends ItemMulti
implements IColorableItem,
IEnchantableItem,
IFluidContainerItem,
IMultiModeItem {
    public static final int TINT_INDEX_FLUID = 1;
    public static final int TINT_INDEX_0 = 2;
    public static final int TINT_INDEX_1 = 3;

    public ItemMultiPotion(String modName) {
        super(modName);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Fluid"}));
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return this.colorMultiplier(stack, 1);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathHelper.clamp((double)(1.0 - (double)this.getFluidAmount(stack) / (double)this.getCapacity(stack)), (double)0.0, (double)1.0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !ItemMultiPotion.isCreative((ItemStack)stack) && this.getFluidAmount(stack) > 0;
    }

    protected abstract int getMaxFluidAmount(ItemStack var1);

    public int getFluidAmount(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        return fluid == null ? 0 : fluid.amount;
    }

    public int getScaledFluidStored(ItemStack stack, int scale) {
        return MathHelper.round((double)((long)this.getFluidAmount(stack) * (long)scale / (long)this.getCapacity(stack)));
    }

    @SideOnly(value=Side.CLIENT)
    protected static void addPotionTooltip(NBTTagCompound potionTag, List<String> lores) {
        List list = PotionUtils.func_185185_a((NBTTagCompound)potionTag);
        if (list.isEmpty()) {
            String s = StringHelper.localize((String)"effect.none").trim();
            lores.add(TextFormatting.GRAY + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = StringHelper.localize((String)potioneffect.func_76453_d()).trim();
                Potion potion = potioneffect.func_188419_a();
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + StringHelper.localize((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                }
                if (potion.func_76398_f()) {
                    lores.add(TextFormatting.RED + s1);
                    continue;
                }
                lores.add(TextFormatting.BLUE + s1);
            }
        }
    }

    public int colorMultiplier(ItemStack stack, int tintIndex) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && tintIndex == 1) {
            return FluidPotion.getPotionColor((FluidStack)fluid);
        }
        return 0xFFFFFF;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return !ItemMultiPotion.isCreative((ItemStack)stack) && enchantment == CoreEnchantments.holding;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack stack) {
        return this.getMaxFluidAmount(stack);
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (resource == null || resource.amount <= 0 || !TFFluids.isPotion((FluidStack)resource)) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (ItemMultiPotion.isCreative((ItemStack)container)) {
            if (doFill) {
                NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
                fluidTag.func_74768_a("Amount", capacity - 1000);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            }
            return resource.amount;
        }
        if (!doFill) {
            if (!container.func_77978_p().func_74764_b("Fluid")) {
                return Math.min(capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.amount, resource.amount);
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", capacity);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.amount);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (stack == null || !stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = capacity;
        }
        container.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        int drained;
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid") || maxDrain == 0) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        boolean creative = ItemMultiPotion.isCreative((ItemStack)container);
        int n = drained = creative ? maxDrain : Math.min(stack.amount, maxDrain);
        if (doDrain && !creative) {
            if (maxDrain >= stack.amount) {
                container.func_77978_p().func_82580_o("Fluid");
                return stack;
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        stack.amount = drained;
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapper(stack, (IFluidContainerItem)this);
    }
}

