/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.block.base.util.info.misc.IPumpTile;
import ic2.core.block.generator.container.ContainerSolarTurbine;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.util.math.Box2D;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntitySolarTurbine
extends TileEntityGeneratorBase
implements IFluidHandler,
IPumpTile {
    public static int maxWater = 40000;
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit16)
    public int heat = 0;
    public float subStorage = 0.0f;
    int ticker;
    float config;

    public TileEntitySolarTurbine() {
        super(2);
        this.maxStorage = 100;
        this.ticker = 127;
        this.config = IC2.config.getInt("energyGeneratorSolarTurbine") / 100;
        this.addGuiFields("heat");
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerSolarTurbine(player.field_71071_by, this);
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.solarTurbine;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.solarTurbine;
    }

    @Override
    public Box2D getEnergyBox() {
        return Ic2GuiComp.nullBox;
    }

    @Override
    public int getPumpCharge() {
        return this.fuel;
    }

    @Override
    public int getMaxPumpCharge() {
        return maxWater;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Heat", this.heat);
        nbt.func_74776_a("SubEnergy", this.subStorage);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74762_e("Heat");
        this.subStorage = nbt.func_74760_g("SubEnergy");
    }

    @Override
    public boolean gainEnergy() {
        if (this.ticker++ % 128 == 0) {
            this.setActive(TileEntitySolarPanel.isSunVisible(this.field_145850_b, this.func_174877_v().func_177984_a()));
        }
        if (this.getActive()) {
            if (this.heat < 24000) {
                this.heat += 2;
                if (this.heat > 24000) {
                    this.heat = 24000;
                }
                this.getNetwork().updateTileGuiField(this, "heat");
            }
        } else if (this.heat > 0) {
            --this.heat;
            this.getNetwork().updateTileGuiField(this, "heat");
        }
        if (this.fuel > 0 && this.heat > 0) {
            float per = this.getHeatPer();
            this.fuel -= Math.round(5.0f * per);
            if (this.fuel < 0) {
                this.fuel = 0;
            }
            this.getNetwork().updateTileGuiField(this, "fuel");
            float gen = (float)this.fuel * per / 4000.0f;
            this.subStorage += (gen *= this.config);
            int adding = (int)this.subStorage;
            if (adding > 0) {
                this.storage += adding;
                this.subStorage -= (float)adding;
            }
            if ((int)gen != this.production) {
                this.production = (int)gen;
                this.getNetwork().updateTileGuiField(this, "production");
            }
        }
        return this.getActive();
    }

    public float getHeatPer() {
        return (float)this.heat / 24000.0f;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel < maxWater;
    }

    @Override
    public boolean gainFuel() {
        if (!((ItemStack)this.inventory.get(1)).func_190926_b()) {
            if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.waterCell)) {
                this.fuel += 2000;
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                return true;
            }
            return FluidHelper.drainContainers(this, this, 1);
        }
        return false;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(FluidRegistry.WATER, this.fuel), maxWater)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != FluidRegistry.WATER) {
            return 0;
        }
        int toAdd = Math.min(resource.amount, (maxWater - this.fuel) / 2);
        if (doFill) {
            this.fuel += toAdd * 2;
            this.getNetwork().updateTileGuiField(this, "fuel");
        }
        return toAdd;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    @Override
    public int getMaxSendingEnergy() {
        return (int)(10.0f * this.config);
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(this.storage, this.getMaxSendingEnergy());
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return super.canSetFacing(player, facing) && facing.func_176740_k().func_176722_c();
    }
}

