/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import ic2.api.classic.item.IFluidScannerItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.low.TileEntityMiner;
import ic2.core.block.machine.med.container.ContainerRangedPump;
import ic2.core.block.misc.BlockMiningPipe;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.helpers.TupleData;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityRangedPump
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui {
    private IFluidHandler[] tanks = new IFluidHandler[6];
    private Set<Integer> iterator = new LinkedHashSet<Integer>();
    TupleData<BlockPos, FluidStack> target = new TupleData();
    int delay = 0;
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit8)
    int progress = 0;

    public TileEntityRangedPump() {
        super(3, 128);
        this.maxEnergy = 30000;
        this.setFuelSlot(0);
        this.addInfos(new ProgressInfo(this));
        this.addGuiFields("progress");
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.DOWN.invert());
        handler.registerDefaultSideAccess(AccessRule.None, RotationList.DOWN);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1, 2);
        handler.registerDefaultSlotsForSide(RotationList.UP, 1);
        handler.registerDefaultSlotsForSide(RotationList.HORIZONTAL, 2);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerInputFilter(CommonFilters.NoneNullBlock, 1);
        handler.registerInputFilter(CommonFilters.Scanners, 2);
        handler.registerSlotType(SlotType.Discharge, 0);
        handler.registerSlotType(SlotType.Tools, 2);
        handler.registerSlotType(SlotType.Input, 1);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerRangedPump(this, player.field_71071_by);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.rangedPump;
    }

    @Override
    public int getTier() {
        return IC2.config.getFlag("MinerLapotron") ? 4 : 2;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        return ((ItemStack)this.inventory.get(2)).func_190926_b() ? 5.0f : 30.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.delay = nbt.func_74762_e("Delay");
        this.progress = nbt.func_74762_e("Progress");
        this.target.clear();
        if (nbt.func_74764_b("TargetKey")) {
            // empty if block
        }
        int[] array = nbt.func_74759_k("TargetKey");
        if (nbt.func_74764_b("TargetValue")) {
            this.target.setData(new BlockPos(array[0], array[1], array[2]), FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("TargetValue")));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Delay", this.delay);
        nbt.func_74768_a("Progress", this.progress);
        if (this.target.hasKey()) {
            BlockPos pos = this.target.getKey();
            nbt.func_74783_a("TargetKey", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
            if (this.target.hasValue()) {
                nbt.func_74782_a("TargetValue", (NBTBase)this.target.getValue().writeToNBT(new NBTTagCompound()));
            }
        }
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.updateTanks();
        }
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.updateTanks();
        }
        if (this.hasEnergy() && ((ItemStack)this.inventory.get(2)).func_77973_b() instanceof IElectricItem) {
            this.energy = (int)((double)this.energy - ElectricItem.manager.charge((ItemStack)this.inventory.get(2), this.energy, 2, true, false));
        }
        this.handleChargeSlot(this.maxEnergy);
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        boolean isOperating = this.isOperating();
        if (isOperating) {
            this.pump();
        } else if (((ItemStack)this.inventory.get(2)).func_190926_b() && this.energy >= 2 && this.canWithdraw()) {
            ++this.progress;
            this.useEnergy(2);
            this.target.clear();
            if (this.progress >= 5) {
                this.progress = 0;
                this.withdrawPipe();
            }
        }
        this.setActive(isOperating);
    }

    public void withdrawPipe() {
        BlockPos target = this.getPipeTip();
        if (!this.field_145850_b.func_175623_d(target)) {
            IBlockState state;
            List list;
            if (this.func_174877_v().func_177956_o() - target.func_177956_o() > 0 && !this.sendItemAway(list = (state = this.field_145850_b.func_180495_p(target)).func_177230_c().getDrops((IBlockAccess)this.func_145831_w(), target, state, 0))) {
                for (int i = 0; i < list.size(); ++i) {
                    StackUtil.dropAsEntity(this.field_145850_b, target, (ItemStack)list.get(i));
                }
            }
            this.field_145850_b.func_175698_g(target);
        }
        if (((ItemStack)this.inventory.get(1)).func_77973_b() != Ic2Items.miningPipe.func_77973_b() && Block.func_149634_a((Item)((ItemStack)this.inventory.get(1)).func_77973_b()) != Blocks.field_150350_a) {
            Item item = ((ItemStack)this.inventory.get(1)).func_77973_b();
            this.field_145850_b.func_175656_a(target, Block.func_149634_a((Item)item).func_176203_a(item.func_77647_b(((ItemStack)this.inventory.get(1)).func_77960_j())));
            ((ItemStack)this.inventory.get(1)).func_190918_g(1);
        }
        this.updateMineTip(target.func_177956_o() + 1);
    }

    public boolean canWithdraw() {
        return BlockMiningPipe.isMiningPipe(this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()));
    }

    public void pump() {
        if (!this.target.hasKey()) {
            this.aquireTarget();
            return;
        }
        if (this.progress < 30) {
            ++this.progress;
            this.useEnergy(10);
            return;
        }
        FluidStack stack = this.target.getValue();
        if (!this.hasPumps() || !this.pumpAway(stack, false)) {
            return;
        }
        this.pumpAway(stack, true);
        this.useEnergy(10);
        BlockPos targetPos = this.target.getKey();
        IBlockState oldState = this.field_145850_b.func_180495_p(targetPos);
        this.field_145850_b.func_180501_a(targetPos, Blocks.field_150350_a.func_176223_P(), 2);
        TileEntityMiner.doBlockUpdates(this.field_145850_b, targetPos, oldState, this.field_174879_c);
        if (targetPos.func_177958_n() == this.field_174879_c.func_177958_n() && targetPos.func_177952_p() == this.field_174879_c.func_177952_p()) {
            this.field_145850_b.func_175656_a(targetPos, Ic2States.miningPipe);
            ((ItemStack)this.inventory.get(1)).func_190918_g(1);
        }
        this.updateMineTip(targetPos.func_177956_o());
        this.target.clear();
    }

    public void aquireTarget() {
        BlockPos target;
        BlockPos pipe = this.getPipeTip();
        if (pipe.func_177956_o() >= this.field_174879_c.func_177956_o()) {
            BlockPos target2 = pipe.func_177977_b();
            if (this.canSetTarget(target2)) {
                this.setTarget(target2, (FluidStack)this.getFluid(target2).func_76341_a());
                return;
            }
            this.delay = 120;
            return;
        }
        IFluidScannerItem item = (IFluidScannerItem)((ItemStack)this.inventory.get(2)).func_77973_b();
        int scanrange = item.startScanningFluidLayer((ItemStack)this.inventory.get(2));
        if (scanrange > 0) {
            AabbUtil.BoundingBox box = new AabbUtil.BoundingBox(pipe, scanrange);
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            LinkedList<BlockPos> work = new LinkedList<BlockPos>();
            visited.add(pipe);
            work.addAll(this.getList(pipe));
            while (work.size() > 0) {
                BlockPos check = (BlockPos)work.remove();
                if (visited.contains(check) || !box.intersectsWith(check)) continue;
                visited.add(check);
                if (!this.field_145850_b.func_175667_e(check)) continue;
                Tuple<FluidStack, Boolean> result = this.getFluid(check);
                FluidStack fluid = (FluidStack)result.func_76341_a();
                if (fluid == null) {
                    if (!((Boolean)result.func_76340_b()).booleanValue()) continue;
                    work.addAll(this.getList(check));
                    continue;
                }
                if (item.isValidFluid((ItemStack)this.inventory.get(2), fluid)) {
                    this.setTarget(check, fluid);
                    return;
                }
                work.addAll(this.getList(check));
            }
        }
        if (this.canSetTarget(target = pipe.func_177977_b())) {
            this.setTarget(target, (FluidStack)this.getFluid(target).func_76341_a());
            return;
        }
        this.delay = 120;
    }

    public List<BlockPos> getList(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            list.add(pos.func_177972_a(dir));
        }
        return list;
    }

    public BlockPos getPipeTip() {
        BlockPos.MutableBlockPos pipe = new BlockPos.MutableBlockPos(this.func_174877_v().func_177977_b());
        while (pipe.func_177956_o() >= 0) {
            IBlockState state = this.field_145850_b.func_180495_p((BlockPos)pipe);
            if (BlockMiningPipe.isMiningPipe(state)) {
                pipe.func_189536_c(EnumFacing.DOWN);
                continue;
            }
            pipe.func_189536_c(EnumFacing.UP);
            break;
        }
        return pipe.func_185334_h();
    }

    public void setTarget(BlockPos newTarget, FluidStack fluid) {
        this.target.setData(newTarget, fluid);
        this.progress = 0;
    }

    public void updateMineTip(int low) {
        if (low == this.func_174877_v().func_177956_o()) {
            return;
        }
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos(this.func_174877_v().func_177977_b());
        while (target.func_177956_o() > low) {
            IBlockState state = this.field_145850_b.func_180495_p((BlockPos)target);
            boolean isMiningPipe = BlockMiningPipe.isMiningPipe(state);
            boolean isTip = BlockMiningPipe.isMiningPipeTip(state);
            if (!isMiningPipe && ((ItemStack)this.inventory.get(1)).func_190916_E() > 0 || isTip) {
                this.field_145850_b.func_175656_a((BlockPos)target, Ic2States.miningPipe);
                if (!isMiningPipe) {
                    ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                }
            }
            target.func_185336_p(target.func_177956_o() - 1);
        }
        this.field_145850_b.func_175656_a((BlockPos)target, Ic2States.miningPipeTip);
    }

    public boolean canSetTarget(BlockPos target) {
        IBlockState state = this.field_145850_b.func_180495_p(target);
        if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, target)) {
            return true;
        }
        IFluidHandler handler = FluidHelper.getBlockHandler(state, this.field_145850_b, target);
        return handler != null;
    }

    public boolean canPumpTarget(IBlockState state, BlockPos target) {
        IFluidHandler handler = FluidHelper.getBlockHandler(state, this.field_145850_b, target);
        return handler != null;
    }

    public Tuple<FluidStack, Boolean> getFluid(BlockPos target) {
        IBlockState state = this.field_145850_b.func_180495_p(target);
        if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, target)) {
            return new Tuple(null, (Object)true);
        }
        IFluidHandler handler = FluidHelper.getBlockHandler(state, this.field_145850_b, target);
        if (handler != null) {
            return new Tuple((Object)handler.drain(Integer.MAX_VALUE, false), (Object)true);
        }
        return new Tuple(null, (Object)false);
    }

    public boolean isOperating() {
        return this.hasEnergy() && this.canOperate();
    }

    private boolean canOperate() {
        return ((ItemStack)this.inventory.get(1)).func_77973_b() == Ic2Items.miningPipe.func_77973_b() && ((ItemStack)this.inventory.get(2)).func_77973_b() instanceof IFluidScannerItem;
    }

    private boolean hasEnergy() {
        return this.hasEnergy(100);
    }

    public boolean hasPumps() {
        return this.iterator.size() > 0;
    }

    public void updateTanks() {
        for (Direction dir : Direction.values()) {
            int sideIndex;
            TileEntity tile = dir.applyToTileEntity(this);
            EnumFacing side = dir.toFacing();
            if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
                sideIndex = side.func_176745_a();
                this.iterator.add(sideIndex);
                this.tanks[sideIndex] = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                continue;
            }
            sideIndex = side.func_176745_a();
            this.iterator.remove(sideIndex);
            this.tanks[sideIndex] = null;
        }
    }

    public boolean pumpAway(FluidStack stack, boolean doFill) {
        if (stack == null) {
            return true;
        }
        FluidStack copy = stack.copy();
        for (int iter : this.iterator) {
            IFluidHandler handler = this.tanks[iter];
            copy.amount -= handler.fill(copy, doFill);
            if (copy.amount > 0) continue;
            return true;
        }
        return false;
    }

    public boolean sendItemAway(List<ItemStack> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (Direction dir : Direction.directions) {
            IItemTransporter trans;
            TileEntity tile = dir.applyToTileEntity(this);
            if (tile == null || (trans = TransporterManager.manager.getTransporter(tile, false)) == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = list.get(i);
                if (stack.func_190926_b()) {
                    list.remove(i--);
                    if (!list.isEmpty()) continue;
                    trans.onFinishedActions();
                    return true;
                }
                ItemStack injected = trans.addItem(stack, dir.getInverse().toFacing(), true);
                if (injected.func_190926_b()) continue;
                stack.func_190918_g(injected.func_190916_E());
                if (!stack.func_190926_b()) continue;
                list.remove(i--);
                if (!list.isEmpty()) continue;
                trans.onFinishedActions();
                return true;
            }
            trans.onFinishedActions();
        }
        return false;
    }
}

