/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.classic.tile.IAdvancedComparatorProvider;
import ic2.core.block.wiring.tile.TileEntityAdvComparator;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.ITileEntityModeledBlock;
import ic2.core.util.obj.IBootable;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAdvComparator
extends BlockContainer
implements ITileEntityModeledBlock,
IBootable,
ILocaleBlock {
    public BlockAdvComparator() {
        super(Material.field_151594_q);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149649_H();
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.advComparator;
    }

    @Override
    public void onLoad() {
        Ic2States.advComparator = this.func_176223_P();
        Ic2Items.advComparator = new ItemStack((Block)this);
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityAdvComparator tile = this.getTile((IBlockAccess)worldIn, pos);
        if (tile != null && tile.isSimulating()) {
            if (playerIn.func_70093_af()) {
                tile.rotate();
            } else {
                tile.setMode(tile.getMode() == BlockRedstoneComparator.Mode.COMPARE ? BlockRedstoneComparator.Mode.SUBTRACT : BlockRedstoneComparator.Mode.COMPARE);
            }
            worldIn.func_175685_c(pos, (Block)this, true);
            worldIn.func_190524_a(pos, (Block)this, pos);
            return true;
        }
        return true;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntityAdvComparator comp = this.getTile(source, pos);
        if (comp != null) {
            switch (comp.getFacing()) {
                case DOWN: {
                    return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
                }
                case UP: {
                    return new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
                }
                case WEST: {
                    return new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
                }
                case EAST: {
                    return new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
                case NORTH: {
                    return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
                }
                case SOUTH: {
                    return new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
                }
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityAdvComparator();
    }

    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getCommonPower(blockAccess, pos, side);
    }

    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getCommonPower(blockAccess, pos, side);
    }

    public int getCommonPower(IBlockAccess access, BlockPos pos, EnumFacing side) {
        TileEntityAdvComparator adv;
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileEntityAdvComparator && (adv = (TileEntityAdvComparator)tile).getSide() == side) {
            return adv.getOutputStrength();
        }
        return 0;
    }

    public int getInputSignal(World worldIn, BlockPos pos, IBlockState state, TileEntityAdvComparator tile) {
        int i = this.getRedstoneInput(worldIn, pos, state, tile);
        BlockPos blockpos = pos.func_177972_a(tile.getSide());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        EnumFacing opposite = tile.getSide().func_176734_d();
        if (iblockstate.func_185912_n()) {
            i = this.getComparatorInput(iblockstate, worldIn, blockpos, opposite);
        } else if (i < 15 && iblockstate.func_185915_l() && (iblockstate = worldIn.func_180495_p(blockpos = blockpos.func_177972_a(tile.getSide()))).func_185912_n()) {
            i = this.getComparatorInput(iblockstate, worldIn, blockpos, opposite);
        }
        return i;
    }

    private int getComparatorInput(IBlockState state, World world, BlockPos pos, EnumFacing side) {
        if (state.func_177230_c() instanceof IAdvancedComparatorProvider) {
            return ((IAdvancedComparatorProvider)state.func_177230_c()).getComparatorOutput(state, world, pos, side);
        }
        return state.func_185888_a(world, pos);
    }

    public int getPowerOnSides(IBlockAccess worldIn, BlockPos pos, IBlockState state, TileEntityAdvComparator comp) {
        EnumFacing facing = comp.getSide();
        EnumFacing enumfacing1 = facing.func_176732_a(comp.getAxis());
        EnumFacing enumfacing2 = facing.func_176734_d().func_176732_a(comp.getAxis());
        return Math.max(this.getPowerOnSide(worldIn, pos.func_177972_a(enumfacing1), enumfacing1), this.getPowerOnSide(worldIn, pos.func_177972_a(enumfacing2), enumfacing2));
    }

    public int getPowerOnSide(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return iblockstate.func_185897_m() ? (block == Blocks.field_150451_bX ? 15 : (block == Blocks.field_150488_af ? ((Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).intValue() : worldIn.func_175627_a(pos, side))) : 0;
    }

    public int getRedstoneInput(World worldIn, BlockPos pos, IBlockState state, TileEntityAdvComparator tile) {
        BlockPos blockpos = pos.func_177972_a(tile.getSide());
        int i = worldIn.func_175651_c(blockpos, tile.getSide());
        if (i >= 15) {
            return i;
        }
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        return Math.max(i, iblockstate.func_177230_c() == Blocks.field_150488_af ? (Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) : 0);
    }

    public boolean shouldBePowered(int input, int side) {
        if (input >= 15) {
            return true;
        }
        if (input == 0) {
            return false;
        }
        return side == 0 ? true : input >= side;
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.func_180495_p(pos.func_177972_a(side.func_176734_d())).func_185913_b() && super.func_176198_a(worldIn, pos, side);
    }

    public boolean canBlockStay(IBlockState state, World worldIn, BlockPos pos) {
        TileEntityAdvComparator tile = this.getTile((IBlockAccess)worldIn, pos);
        if (tile != null) {
            return worldIn.func_180495_p(pos.func_177972_a(tile.getFacing())).func_185913_b();
        }
        return false;
    }

    public void updateState(IBlockState state, World worldIn, BlockPos pos) {
        TileEntityAdvComparator tile;
        if (!worldIn.func_175691_a(pos, (Block)this) && (tile = this.getTile((IBlockAccess)worldIn, pos)) != null) {
            int output;
            int input = this.getInputSignal(worldIn, pos, state, tile);
            int sideInput = this.getPowerOnSides((IBlockAccess)worldIn, pos, state, tile);
            int n = output = tile.getMode() == BlockRedstoneComparator.Mode.SUBTRACT ? Math.max(input - sideInput, 0) : input;
            if (tile.getOutputStrength() != output) {
                if (this.isFacingRepeater(worldIn, pos, tile.getSide().func_176734_d())) {
                    worldIn.func_175654_a(pos, (Block)this, 2, -1);
                } else {
                    worldIn.func_175654_a(pos, (Block)this, 2, 0);
                }
            }
        }
    }

    public boolean isFacingRepeater(World world, BlockPos pos, EnumFacing side) {
        BlockPos offset = pos.func_177972_a(side);
        IBlockState state = world.func_180495_p(offset);
        if (state.func_177230_c() == this) {
            TileEntityAdvComparator comp = this.getTile((IBlockAccess)world, offset);
            if (comp != null) {
                return comp.getSide() != side;
            }
            return false;
        }
        return BlockRedstoneDiode.func_185546_B((IBlockState)state) ? state.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) != side : false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntityAdvComparator tile = this.getTile((IBlockAccess)worldIn, pos);
        if (tile != null) {
            int input = this.getInputSignal(worldIn, pos, state, tile);
            int sideInput = this.getPowerOnSides((IBlockAccess)worldIn, pos, state, tile);
            tile.setOutputStrength((byte)(tile.getMode() == BlockRedstoneComparator.Mode.SUBTRACT ? Math.max(input - sideInput, 0) : input));
            tile.setActive(this.shouldBePowered(input, sideInput));
            this.updateBlocks(worldIn, pos, tile.getSide());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityAdvComparator tile = this.getTile((IBlockAccess)worldIn, pos);
        if (tile != null) {
            tile.setOutputStrength((byte)0);
            this.updateBlocks(worldIn, pos, tile.getSide());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void updateBlocks(World world, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side.func_176734_d());
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)world.func_180495_p(pos), EnumSet.of(side.func_176734_d()), (boolean)true).isCanceled()) {
            return;
        }
        world.func_190524_a(blockpos, (Block)this, pos);
        world.func_175695_a(blockpos, (Block)this, side);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos origin) {
        if (this.canBlockStay(state, worldIn, pos)) {
            this.updateState(state, worldIn, pos);
        } else {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, true);
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (world instanceof World) {
            this.func_189540_a(world.func_180495_p(pos), (World)world, pos, world.func_180495_p(neighbor).func_177230_c(), pos);
        }
    }

    private TileEntityAdvComparator getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAdvComparator) {
            return (TileEntityAdvComparator)tile;
        }
        return null;
    }

    @Override
    public List<IBlockState> getTileStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public Class<? extends TileEntity> getClassFromState(IBlockState state) {
        return TileEntityAdvComparator.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticalTexture(IBlockState state) {
        return Ic2Icons.getTextures("bcable")[195];
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176223_P();
    }
}

